{{-- To make a editable image or text need to be add a "builder editable" class and builder identity attribute with a unique value --}}
{{-- "builder identity" and "builder editable" --}}
{{-- builder identity value have to be unique under a single file --}}

<!-- Start Brand Story -->
<section class="brand-story-section section-mb overflow-hidden">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="brand-story-area">
                    <div class="brand-story-banners">
                        <div class="brand-story-banner1 wow animate__slideInLeft" data-wow-delay=".3s">
                            <img class="banner builder-editable" builder-identity="sB1" src="{{ asset('assets/frontend/shoe/images/brand-story-banner1.webp') }}" alt="banner">
                            <div class="brand-story-banner-content">
                                <h3 class="bs-banner-title builder-editable" builder-identity="sB2">{{get_phrase('Our Client Reviews')}}</h3>
                                @php 
                                $reviews = App\Models\Review::where('rating', 5)->latest()->take(10)->get(); 
                                @endphp
                                @if(!empty($reviews))
                                <div class="d-flex align-items-center gap-10px mb-4">
                                    <ul class="bs-banner-stars">
                                         
                                        <li class="bs-banner-star">
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M9.99424 16.6L4.66039 19.8362C4.53567 19.9119 4.39126 19.9492 4.24535 19.9433C4.09944 19.9374 3.95853 19.8886 3.84035 19.803C3.72217 19.7175 3.632 19.5989 3.58118 19.4624C3.53035 19.3258 3.52115 19.1773 3.55472 19.0355L4.99209 12.9739L0.257472 8.91353C0.146799 8.81853 0.0667529 8.693 0.0274002 8.55274C-0.0119526 8.41247 -0.00885557 8.26373 0.0363017 8.12522C0.0814589 7.98671 0.16666 7.86461 0.281192 7.77427C0.395724 7.68393 0.534474 7.62939 0.679994 7.61751L6.90232 7.10836L9.3111 1.36194C9.36741 1.22752 9.46231 1.11272 9.58387 1.03197C9.70542 0.95122 9.8482 0.908136 9.99424 0.908136C10.1403 0.908136 10.2831 0.95122 10.4046 1.03197C10.5262 1.11272 10.6211 1.22752 10.6774 1.36194L13.0862 7.10836L19.3085 7.61751C19.4539 7.62957 19.5925 7.68423 19.7069 7.77463C19.8213 7.86504 19.9064 7.98715 19.9514 8.12563C19.9965 8.26411 19.9995 8.41278 19.9601 8.55296C19.9207 8.69315 19.8407 8.81859 19.73 8.91353L14.9964 12.9739L16.4338 19.0355C16.4673 19.1773 16.4581 19.3258 16.4073 19.4624C16.3565 19.5989 16.2663 19.7175 16.1481 19.803C16.03 19.8886 15.889 19.9374 15.7431 19.9433C15.5972 19.9492 15.4528 19.9119 15.3281 19.8362L9.99424 16.6Z" fill="#FFBB0E"/>
                                            </svg>
                                        </li>
                                        <li class="bs-banner-star">
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M9.99424 16.6L4.66039 19.8362C4.53567 19.9119 4.39126 19.9492 4.24535 19.9433C4.09944 19.9374 3.95853 19.8886 3.84035 19.803C3.72217 19.7175 3.632 19.5989 3.58118 19.4624C3.53035 19.3258 3.52115 19.1773 3.55472 19.0355L4.99209 12.9739L0.257472 8.91353C0.146799 8.81853 0.0667529 8.693 0.0274002 8.55274C-0.0119526 8.41247 -0.00885557 8.26373 0.0363017 8.12522C0.0814589 7.98671 0.16666 7.86461 0.281192 7.77427C0.395724 7.68393 0.534474 7.62939 0.679994 7.61751L6.90232 7.10836L9.3111 1.36194C9.36741 1.22752 9.46231 1.11272 9.58387 1.03197C9.70542 0.95122 9.8482 0.908136 9.99424 0.908136C10.1403 0.908136 10.2831 0.95122 10.4046 1.03197C10.5262 1.11272 10.6211 1.22752 10.6774 1.36194L13.0862 7.10836L19.3085 7.61751C19.4539 7.62957 19.5925 7.68423 19.7069 7.77463C19.8213 7.86504 19.9064 7.98715 19.9514 8.12563C19.9965 8.26411 19.9995 8.41278 19.9601 8.55296C19.9207 8.69315 19.8407 8.81859 19.73 8.91353L14.9964 12.9739L16.4338 19.0355C16.4673 19.1773 16.4581 19.3258 16.4073 19.4624C16.3565 19.5989 16.2663 19.7175 16.1481 19.803C16.03 19.8886 15.889 19.9374 15.7431 19.9433C15.5972 19.9492 15.4528 19.9119 15.3281 19.8362L9.99424 16.6Z" fill="#FFBB0E"/>
                                            </svg>
                                        </li>
                                        <li class="bs-banner-star">
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M9.99424 16.6L4.66039 19.8362C4.53567 19.9119 4.39126 19.9492 4.24535 19.9433C4.09944 19.9374 3.95853 19.8886 3.84035 19.803C3.72217 19.7175 3.632 19.5989 3.58118 19.4624C3.53035 19.3258 3.52115 19.1773 3.55472 19.0355L4.99209 12.9739L0.257472 8.91353C0.146799 8.81853 0.0667529 8.693 0.0274002 8.55274C-0.0119526 8.41247 -0.00885557 8.26373 0.0363017 8.12522C0.0814589 7.98671 0.16666 7.86461 0.281192 7.77427C0.395724 7.68393 0.534474 7.62939 0.679994 7.61751L6.90232 7.10836L9.3111 1.36194C9.36741 1.22752 9.46231 1.11272 9.58387 1.03197C9.70542 0.95122 9.8482 0.908136 9.99424 0.908136C10.1403 0.908136 10.2831 0.95122 10.4046 1.03197C10.5262 1.11272 10.6211 1.22752 10.6774 1.36194L13.0862 7.10836L19.3085 7.61751C19.4539 7.62957 19.5925 7.68423 19.7069 7.77463C19.8213 7.86504 19.9064 7.98715 19.9514 8.12563C19.9965 8.26411 19.9995 8.41278 19.9601 8.55296C19.9207 8.69315 19.8407 8.81859 19.73 8.91353L14.9964 12.9739L16.4338 19.0355C16.4673 19.1773 16.4581 19.3258 16.4073 19.4624C16.3565 19.5989 16.2663 19.7175 16.1481 19.803C16.03 19.8886 15.889 19.9374 15.7431 19.9433C15.5972 19.9492 15.4528 19.9119 15.3281 19.8362L9.99424 16.6Z" fill="#FFBB0E"/>
                                            </svg>
                                        </li>
                                        <li class="bs-banner-star">
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M9.99424 16.6L4.66039 19.8362C4.53567 19.9119 4.39126 19.9492 4.24535 19.9433C4.09944 19.9374 3.95853 19.8886 3.84035 19.803C3.72217 19.7175 3.632 19.5989 3.58118 19.4624C3.53035 19.3258 3.52115 19.1773 3.55472 19.0355L4.99209 12.9739L0.257472 8.91353C0.146799 8.81853 0.0667529 8.693 0.0274002 8.55274C-0.0119526 8.41247 -0.00885557 8.26373 0.0363017 8.12522C0.0814589 7.98671 0.16666 7.86461 0.281192 7.77427C0.395724 7.68393 0.534474 7.62939 0.679994 7.61751L6.90232 7.10836L9.3111 1.36194C9.36741 1.22752 9.46231 1.11272 9.58387 1.03197C9.70542 0.95122 9.8482 0.908136 9.99424 0.908136C10.1403 0.908136 10.2831 0.95122 10.4046 1.03197C10.5262 1.11272 10.6211 1.22752 10.6774 1.36194L13.0862 7.10836L19.3085 7.61751C19.4539 7.62957 19.5925 7.68423 19.7069 7.77463C19.8213 7.86504 19.9064 7.98715 19.9514 8.12563C19.9965 8.26411 19.9995 8.41278 19.9601 8.55296C19.9207 8.69315 19.8407 8.81859 19.73 8.91353L14.9964 12.9739L16.4338 19.0355C16.4673 19.1773 16.4581 19.3258 16.4073 19.4624C16.3565 19.5989 16.2663 19.7175 16.1481 19.803C16.03 19.8886 15.889 19.9374 15.7431 19.9433C15.5972 19.9492 15.4528 19.9119 15.3281 19.8362L9.99424 16.6Z" fill="#FFBB0E"/>
                                            </svg>
                                        </li>
                                        <li class="bs-banner-star">
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M9.99424 16.6L4.66039 19.8362C4.53567 19.9119 4.39126 19.9492 4.24535 19.9433C4.09944 19.9374 3.95853 19.8886 3.84035 19.803C3.72217 19.7175 3.632 19.5989 3.58118 19.4624C3.53035 19.3258 3.52115 19.1773 3.55472 19.0355L4.99209 12.9739L0.257472 8.91353C0.146799 8.81853 0.0667529 8.693 0.0274002 8.55274C-0.0119526 8.41247 -0.00885557 8.26373 0.0363017 8.12522C0.0814589 7.98671 0.16666 7.86461 0.281192 7.77427C0.395724 7.68393 0.534474 7.62939 0.679994 7.61751L6.90232 7.10836L9.3111 1.36194C9.36741 1.22752 9.46231 1.11272 9.58387 1.03197C9.70542 0.95122 9.8482 0.908136 9.99424 0.908136C10.1403 0.908136 10.2831 0.95122 10.4046 1.03197C10.5262 1.11272 10.6211 1.22752 10.6774 1.36194L13.0862 7.10836L19.3085 7.61751C19.4539 7.62957 19.5925 7.68423 19.7069 7.77463C19.8213 7.86504 19.9064 7.98715 19.9514 8.12563C19.9965 8.26411 19.9995 8.41278 19.9601 8.55296C19.9207 8.69315 19.8407 8.81859 19.73 8.91353L14.9964 12.9739L16.4338 19.0355C16.4673 19.1773 16.4581 19.3258 16.4073 19.4624C16.3565 19.5989 16.2663 19.7175 16.1481 19.803C16.03 19.8886 15.889 19.9374 15.7431 19.9433C15.5972 19.9492 15.4528 19.9119 15.3281 19.8362L9.99424 16.6Z" fill="#FFBB0E"/>
                                            </svg>
                                        </li>
                                        
                                    </ul>
                                    {{-- <h4 class="bs-banner-rating">5.0</h4> --}}
                                </div>
                                @endif

                                <ul class="bs-banner-profiles">
                                    @foreach($reviews->take(4)  as $review)
                                    <li class="bs-banner-profile">
                                        <img class="user" src="{{ get_image($review->user->photo) }}" alt="">
                                    </li>
                                    @endforeach
                                 </ul>

                            </div>
                        </div>
                        <div class="brand-story-banner2 wow animate__slideInLeft" data-wow-delay=".2s">
                            <img class="banner builder-editable" builder-identity="sB3" src="{{ asset('assets/frontend/shoe/images/brand-story-banner2.webp') }}" alt="banner">
                        </div>
                    </div>
                    <div class="brand-story-title-area">
                        <p class="title-badge mb-30px wow animate__fadeInUp builder-editable" builder-identity="sB4" data-wow-delay=".1s">{{get_phrase('Brand Story')}}</p>
                        <h2 class="section-title text-capitalize mb-20px wow animate__fadeInUp builder-editable" builder-identity="sB5" data-wow-delay=".2s">{{get_phrase('More Than Footwear — A Way of Life!')}}</h2>
                        <p class="brand-story-subtitle wow animate__fadeInUp builder-editable" builder-identity="sB6" data-wow-delay=".3s">{{get_phrase('At Shoe World, we believe in empowering movement — from early morning jogs to late-night events. Our shoes are designed for real life, inspired by real people. Each pair is crafted with premium materials and timeless design to bring you durability, style, and unmatched comfort.')}}</p>
                       
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End Brand Story -->