<!-- Banner Area Start  -->
<section class="bs-banner-section">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="banner-title-area">
                    <h1 class="banner-title wow animate__fadeInUp" data-wow-delay=".1s">
                        <span>{{get_phrase('Carry Style Comfort')}} <span class="bs-text-skin">{{get_phrase('&')}}</span> {{get_phrase('Purpose!')}}</span>
                        <img class="banner-title-shape" src="{{ asset('assets/frontend/bags/images/banner-title-shape2.png') }}" alt="shape">
                    </h1>
                    <p class="banner-subtitle wow animate__fadeInUp" data-wow-delay=".2s">{{get_phrase('Discover bags built for every journey. From workdays to getaways, we’ve got your back.')}}</p>
                </div>
                <div class="banner-btn-area wow animate__fadeInUp" data-wow-delay=".3s">
                    <a href="{{route('all_products')}}" class="btn bsb3-btn-skin">
                        <span>{{get_phrase('Shop Now!')}}</span>
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
                            <path d="M2 10.5L0.5 10.5L0.5 13.5L2 13.5L2 10.5ZM24.0607 13.0607C24.6464 12.4749 24.6464 11.5251 24.0607 10.9393L14.5147 1.3934C13.9289 0.80761 12.9792 0.807611 12.3934 1.3934C11.8076 1.97918 11.8076 2.92893 12.3934 3.51472L20.8787 12L12.3934 20.4853C11.8076 21.0711 11.8076 22.0208 12.3934 22.6066C12.9792 23.1924 13.9289 23.1924 14.5147 22.6066L24.0607 13.0607ZM2 12L2 13.5L23 13.5L23 12L23 10.5L2 10.5L2 12Z" fill="white"/>
                        </svg>
                    </a>
                    <img class="banner-arrow-shape" src="{{ asset('assets/frontend/bags/images/banner-arrow-shape.svg') }}" alt="arrow">
                </div>
                <div class="bs-banner-wrap wow animate__fadeInUp" data-wow-delay=".4s">
                    <div class="bs-banner-badge">
                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 48 48" fill="none">
                            <path d="M37.7553 0.979795C38.3154 0.860735 38.8667 1.21913 38.9864 1.78089C40.351 8.18662 39.2784 14.8202 36.066 20.4057L36.0433 20.4445L37.7624 28.5134C37.8127 28.7494 37.7799 28.9945 37.6706 29.2069L37.6186 29.2959L30.9927 39.5312C30.7926 39.8402 30.448 40.0162 30.089 40.0043L29.9346 39.9872C29.522 39.9107 29.1955 39.5924 29.1078 39.1809L27.8325 33.1951L27.6799 33.4303L27.5809 33.5842C26.6069 35.089 24.6342 35.5503 23.1014 34.6604L22.9543 34.5699L14.4145 29.0176C12.9117 28.0406 12.4494 26.0637 13.3363 24.5285L13.4268 24.3814L13.5258 24.2275L13.6776 23.9935L7.70425 25.2662C7.3452 25.3426 6.97631 25.2227 6.73029 24.9595L6.63338 24.8373C6.4252 24.5341 6.39399 24.1475 6.54229 23.8193L6.617 23.6826L13.2427 13.4463C13.3923 13.2153 13.6275 13.0528 13.8965 12.9955L21.9482 11.2801L21.9746 11.2445C25.7494 6.03447 31.353 2.34385 37.7553 0.979795ZM34.3059 23.195L29.4543 30.6889L29.4289 30.7292L30.6145 36.2938L30.7661 36.0588L35.6175 28.564L35.643 28.5246L34.4575 22.9601L34.3059 23.195ZM24.186 29.2113L22.5725 31.7048L22.5094 31.8021L22.6067 31.8652L24.0834 32.8257C24.6344 33.1838 25.361 33.0585 25.7634 32.5566L25.8389 32.4516L26.8261 30.9273L26.8893 30.83L26.792 30.7668L24.3465 29.1771L24.2491 29.114L24.186 29.2113ZM20.5361 26.8377L18.9216 29.3314L18.8585 29.4287L18.9558 29.4919L20.67 30.6064L20.7676 30.6705L20.8305 30.5722L22.4449 28.0785L22.5081 27.9812L22.4109 27.919L20.6965 26.8035L20.5992 26.7404L20.5361 26.8377ZM30.0073 6.40283C27.3826 8.11472 25.0996 10.3407 23.2821 12.9948L22.9241 13.5314L17.4095 22.0511L17.3463 22.1485L17.4437 22.2116L27.9201 29.0228L28.0174 29.0859L28.0806 28.9886L33.5962 20.4686C35.4773 17.5623 36.6927 14.3551 37.2108 11.0307L37.2296 10.9079L37.1055 10.8974C34.2346 10.6609 31.6024 8.98873 30.1717 6.44367L30.1108 6.33583L30.0073 6.40283ZM16.1551 23.9899L15.1678 25.5142C14.8111 26.0657 14.9364 26.7937 15.4375 27.1971L15.5425 27.2726L17.0192 28.233L17.1165 28.2962L17.1796 28.1988L18.7941 25.7051L18.8572 25.6078L18.7599 25.5447L16.3155 23.9557L16.218 23.8916L16.1551 23.9899ZM14.7239 14.9809L9.87329 22.4746L9.72166 22.7096L15.2748 21.5265L15.3011 21.4859L20.1517 13.9923L20.3033 13.7573L14.7502 14.9404L14.7239 14.9809ZM37.0332 3.28936C35.2743 3.75341 33.5929 4.40703 32.0114 5.23197L31.9052 5.28655L31.9643 5.39077C33.062 7.35199 35.0946 8.6533 37.3322 8.82614L37.4499 8.83501L37.4569 8.7177C37.5589 6.95122 37.4682 5.16395 37.1769 3.38256L37.156 3.25622L37.0332 3.28936Z" fill="white" stroke="black" stroke-width="0.231841"/>
                            <path d="M8.67286 35.1476C10.583 32.1968 14.4713 31.2889 17.4782 33.0329L17.7666 33.2101C20.7137 35.1262 21.6235 39.0225 19.8852 42.0336L19.7082 42.3229C18.9388 43.5114 17.2247 44.6024 14.4398 45.6391L13.8687 45.8456C12.3474 46.3805 10.52 46.8836 9.67499 47.0636C9.14515 47.1764 8.62529 46.862 8.46789 46.3563L8.44189 46.253C8.42764 46.1829 8.12497 44.6835 7.92271 42.771L7.84301 41.9283C7.58748 38.8285 7.81992 36.6957 8.5262 35.3965L8.67286 35.1476ZM16.6385 34.9542C14.6218 33.643 11.9389 34.1603 10.546 36.0895L10.4149 36.2801C10.1785 36.6454 10.0265 37.1754 9.93436 37.7974C9.84188 38.422 9.80825 39.1517 9.81754 39.9251C9.83613 41.4721 10.0249 43.206 10.2592 44.6506L10.2801 44.777L10.4038 44.7436C11.8156 44.3692 13.4724 43.8363 14.8895 43.2228C15.598 42.916 16.2493 42.588 16.7808 42.2487C17.2437 41.9532 17.6233 41.644 17.8694 41.3268L17.9671 41.1902C19.2744 39.1705 18.7558 36.4819 16.8292 35.0853L16.6385 34.9542Z" fill="white" stroke="black" stroke-width="0.231841"/>
                            <path d="M29.4965 13.0987C29.7971 12.6342 30.4059 12.4899 30.8803 12.761L30.973 12.8211C31.4009 13.1289 31.5473 13.7528 31.209 14.2755L31.1603 14.3518L31.2225 14.4184C31.4936 14.7066 31.6902 14.988 31.8576 15.2906L32.0178 15.6019C32.2558 16.1022 32.0596 16.6971 31.5812 16.96L31.4817 17.0082C31.0333 17.1967 30.4713 17.0441 30.1699 16.5358L30.1122 16.4293C29.9666 16.1238 29.6593 15.7024 29.2291 15.4572L29.0374 15.3632C28.7819 15.2592 28.4752 15.2585 28.2392 15.4315L28.1425 15.517C28.0195 15.6462 27.9765 15.7739 27.9617 15.854L27.9541 15.9166C27.9506 16.0319 28.006 16.1739 28.0778 16.3145C28.1527 16.4611 28.2576 16.6283 28.3753 16.8013C28.4929 16.9744 28.6253 17.1566 28.7583 17.3338L29.1435 17.8388C30.0261 18.9885 30.0319 20.4386 29.188 21.5347L29.008 21.7488C28.1819 22.6515 26.959 23.0017 25.8236 22.7368L25.7449 22.7186L25.5434 23.0291C25.2427 23.4938 24.6339 23.6374 24.1594 23.3659L24.0669 23.3068C23.644 23.0025 23.5273 22.4215 23.767 21.9598L23.8195 21.8687L23.9405 21.6822L23.8694 21.6155C23.5429 21.3113 23.2825 20.9611 23.0314 20.4521L22.9239 20.2243C22.7032 19.7323 22.8683 19.1517 23.307 18.8776L23.3981 18.8273C23.8965 18.5842 24.4866 18.7763 24.754 19.2443L24.8028 19.3418C24.9398 19.6524 25.0483 19.8522 25.2113 20.0266C25.3317 20.1555 25.4796 20.2675 25.6818 20.4026L25.9042 20.5469C26.2453 20.7653 26.5758 20.7875 26.8539 20.716C27.0594 20.6631 27.2344 20.56 27.3637 20.4516L27.4775 20.3435C27.5924 20.2179 27.7046 20.0447 27.7325 19.8299C27.7572 19.6387 27.7133 19.4274 27.5679 19.203L27.4993 19.1057C26.9565 18.3988 26.4283 17.6605 26.1171 16.939L25.9975 16.631C25.6874 15.7255 25.9917 14.7616 26.6421 14.0793C27.2917 13.3977 28.2764 13.0092 29.3087 13.2486L29.3875 13.2667L29.4965 13.0987Z" fill="white" stroke="black" stroke-width="0.231841"/>
                        </svg>
                        <p>{{get_phrase('Popular Trendy Laptop Bags')}}</p>
                    </div>
                    <img class="banner d-none d-lg-block" src="{{ asset('assets/frontend/bags/images/banner.webp') }}" alt="banner">
                    <img class="banner d-block d-lg-none" src="{{ asset('assets/frontend/bags/images/banner-sm.webp') }}" alt="banner">
                    <div class="banner-card-outer">
                        <div class="bs-banner-card">
                            <p class="banner-card-title">{{get_phrase('Limited-Time Offers Available Just for You!')}}</p>
                            <div>
                                <a href="{{route('all_products')}}" class="btn bsb2-btn-white">{{get_phrase('View All Deals')}}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Banner Area End  -->

<!-- Brand Area Start -->
<section>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="trusted-brand-area">
                    <h4 class="trusted-brand-title wow animate__fadeInUp" data-wow-delay=".1s">{{get_phrase('OUR TRUSTED BRANDS:')}}</h4>
                    <ul class="trusted-brand-list wow animate__fadeInUp" data-wow-delay=".2s">
                        @php 
                            $brands = App\Models\Brand::take(5)->get();
                         @endphp
                              @foreach($brands as $brand) 
                        <li>
                            <a href="javascript:;" class="trusted-brand">
                                <img class="brand" src="{{ get_image($brand->logo) }}" alt="brand">
                            </a>
                        </li>
                       @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Brand Area End -->

<!-- Featured Categories Area Start -->
<section class="section-mb">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="featured-category-title-area">
                    <p class="bs-title-badge mx-auto mb-26px wow animate__fadeInUp" data-wow-delay=".1s">{{get_phrase('Featured Categories')}}</p>
                    <h2 class="section-title text-center max-w-898px mx-auto mb-14px wow animate__fadeInUp" data-wow-delay=".2s">{{get_phrase('Explore Bags for Every Lifestyle!')}}</h2>
                    <p class="section-subtitle text-center max-w-580px mx-auto featured-category-subtitle wow animate__fadeInUp" data-wow-delay=".3s">{{get_phrase('Find the perfect match for your daily hustle, tech needs, or weekend escapes.')}}</p>
                    <div class="d-flex align-items-center justify-content-center flex-wrap gap-12px wow animate__fadeInUp" data-wow-delay=".4s">
                        <a href="{{route('all_products')}}" class="btn bs-btn-skin">
                            <span>{{get_phrase('Shop Now!')}}</span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="20" viewBox="0 0 22 20" fill="none">
                                <path d="M1.77997 8.65667L0.436635 8.65667L0.436635 11.3433L1.77997 11.3433L1.77997 8.65667ZM21.5365 10.9499C22.0611 10.4253 22.0611 9.57472 21.5365 9.05012L12.9876 0.501199C12.463 -0.023406 11.6124 -0.0234059 11.0878 0.501199C10.5632 1.0258 10.5632 1.87635 11.0878 2.40096L18.6869 10L11.0878 17.599C10.5632 18.1236 10.5632 18.9742 11.0878 19.4988C11.6124 20.0234 12.463 20.0234 12.9876 19.4988L21.5365 10.9499ZM1.77997 10L1.77997 11.3433L20.5866 11.3433L20.5866 10L20.5866 8.65667L1.77997 8.65667L1.77997 10Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="row wow animate__fadeInUp" data-wow-delay=".1s">
            <div class="col-12">
                <!-- Swiper -->
                <div class="swiper category-slider">
                    <div class="swiper-wrapper">
                        @php
                            $categories = App\Models\Category::where('parent_id', '=', 0)->orderBy('sort', 'asc')->orderBy('title', 'asc')->get();
                        @endphp
                        @foreach($categories as $category)
                        <div class="swiper-slide">
                            <a href="{{ route('products', $category->slug) }}" class="category-card">
                                <div class="category-card-banner">
                                    <img class="banner" src="{{ get_image($category->thumbnail) }}" alt="banner">
                                </div>
                                <div class="category-card-content">
                                    <h3 class="category-card-title">{{$category->title}}</h3>
                                    <div class="category-card-btn">
                                        <div class="category-btn-inner">
                                            <svg width="30" height="31" viewBox="0 0 30 31" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M0.990773 29.2923C0.271274 28.4341 0.336796 27.0452 1.18775 26.1913L21.1581 6.15067L22.0322 5.27357L20.8512 5.246L8.21049 4.95274C7.17662 4.92861 6.38141 4.05638 6.34481 2.95556L6.3478 2.73209C6.41568 1.58947 7.27148 0.663949 8.29801 0.57397L8.50545 0.566998L27.1486 0.999376C27.6811 1.01174 28.1734 1.25422 28.5204 1.66769C28.8239 2.02957 28.9988 2.50143 29.0146 3.00307L29.0112 3.22003L27.8033 23.5734C27.7354 24.7161 26.8798 25.6418 25.8531 25.7315L25.6456 25.7385C24.6117 25.7143 23.817 24.8415 23.7806 23.7406L23.7829 23.5178L24.6023 9.71799L24.6788 8.42728L3.83305 29.345L3.66898 29.4944C2.82539 30.1899 1.66566 30.0969 0.990773 29.2923Z" fill="white" stroke="#DA5C19"/>
                                            </svg>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                        @endforeach
                    </div>
                    <div class="category-slider-navs wow animate__fadeInUp" data-wow-delay=".2s">
                        <div class="swiper-button-prev">
                            <svg width="29" height="27" viewBox="0 0 29 27" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M27.5507 13.8552L2.15936 13.8552M2.15936 13.8552L14.1497 25.4929M2.15936 13.8552L14.1497 2.21756" stroke="black" stroke-width="2.64493" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="swiper-button-next">
                            <svg width="29" height="27" viewBox="0 0 29 27" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M1.5072 13.855H26.8985M26.8985 13.855L14.9082 2.21729M26.8985 13.855L14.9082 25.4926" stroke="black" stroke-width="2.64493" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>                               
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Featured Categories Area End -->

<!-- Best Sellers Area Start -->
<section class="best-sellers-section section-mb">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div>
                    <p class="bs-title-badge mb-26px wow animate__fadeInUp" data-wow-delay=".1s">{{get_phrase('Best Sellers')}}</p>
                    <div class="best-sellers-title-area">
                        <div>
                            <h2 class="section-title wow animate__fadeInUp" data-wow-delay=".2s">{{get_phrase('Top Picks Loved by Customers')}}</h2>
                        </div>
                        <div class="best-sellers-title-right">
                            <p class="section-subtitle mb-30px wow animate__fadeInUp" data-wow-delay=".3s">{{get_phrase('Popular favorites flying off our shelves. Grab yours before they’re gone!')}}</p>
                            <div class="d-flex align-items-center flex-wrap gap-12px wow animate__fadeInUp" data-wow-delay=".4s">
                                <a href="{{route('all_products')}}" class="btn bs-btn-skin">
                                    <span>{{get_phrase('Shop Now!')}}</span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="22" height="20" viewBox="0 0 22 20" fill="none">
                                        <path d="M1.77997 8.65667L0.436635 8.65667L0.436635 11.3433L1.77997 11.3433L1.77997 8.65667ZM21.5365 10.9499C22.0611 10.4253 22.0611 9.57472 21.5365 9.05012L12.9876 0.501199C12.463 -0.023406 11.6124 -0.0234059 11.0878 0.501199C10.5632 1.0258 10.5632 1.87635 11.0878 2.40096L18.6869 10L11.0878 17.599C10.5632 18.1236 10.5632 18.9742 11.0878 19.4988C11.6124 20.0234 12.463 20.0234 12.9876 19.4988L21.5365 10.9499ZM1.77997 10L1.77997 11.3433L20.5866 11.3433L20.5866 10L20.5866 8.65667L1.77997 8.65667L1.77997 10Z" fill="white"/>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row g-4 wow animate__fadeInUp" data-wow-delay=".1s">
            @php 
                $Bestproducted =App\Models\Product::where('status', 1)->where('label', 'best-seller')->latest()->take(3)->get();
            @endphp
               @foreach($Bestproducted as $product)
            <div class="col-md-6 col-xl-4">
                <div class="product-card">
                    <div class="pci-slider-wrap">
                        <!-- Swiper -->
                        <div class="swiper pci-slider">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide">
                                    <div class="pci-slider-image">
                                        @php
                                            $thumbnails = json_decode($product->thumbnail, true);
                                            $firstImage = $thumbnails[0] ?? null;
                                        @endphp
                                        <img class="banner" src="{{ get_image($firstImage) }}" alt="product">
                                    </div>
                                </div>
                            </div>
                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                    <div>
                        <div class="d-flex align-items-center gap-12px flex-wrap pc-rating-wrap">
                            <div class="d-flex align-items-center gap-1">
                                @php
                                    $rating = $product->average_rating;
                                    $fullStars = floor($rating); // full stars count
                                    $halfStar = ($rating - $fullStars) >= 0.5 ? 1 : 0; // half star check
                                    $emptyStars = 5 - ($fullStars + $halfStar);
                                @endphp
                                @for($i = 0; $i < $fullStars; $i++)
                                <div class="svg-block">
                                    <svg width="26" height="25" viewBox="0 0 26 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M13.2351 0.97998L16.9847 9.0486L25.8224 10.119L19.3022 16.176L21.0145 24.9062L13.2351 20.581L5.4557 24.9062L7.168 16.176L0.647771 10.119L9.48542 9.0486L13.2351 0.97998Z" fill="#FFC633"/>
                                    </svg>
                                </div>
                                @endfor
                                  @if($halfStar)
                                    <div class="svg-block">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="31" viewBox="0 0 25 25" fill="none">
                                        <path d="M12.6993 3.7688L10.0072 9.90566L3.62445 10.7014L8.34339 15.2899L7.09074 21.9186L12.6993 18.6175V3.7688Z" fill="#FFC633"/>
                                        <path d="M12.6994 18.6178L18.308 21.9188L17.0553 15.2901L21.7742 10.7016L15.3915 9.90591L12.6994 3.76904V18.6178Z" ffill="url(#halfStarGradient)" stroke="#FFC633" stroke-width="0.5"/>
                                    </svg>
                                    
                                    </div>
                                @endif
                                @for($i = 0; $i < $emptyStars; $i++)
                                <div class="svg-block">
                                    <svg width="26" height="25" viewBox="0 0 26 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M13.2351 0.97998L16.9847 9.0486L25.8224 10.119L19.3022 16.176L21.0145 24.9062L13.2351 20.581L5.4557 24.9062L7.168 16.176L0.647771 10.119L9.48542 9.0486L13.2351 0.97998Z" fill="#ddd"/>
                                    </svg>
                                </div>
                                @endfor
                            </div>
                            <p class="product-card-rating">({{ number_format($product->average_rating, 1) }})</p>
                        </div>
                        <a href="{{ route('product', $product->slug) }}" class="product-card-title">{{$product->title}}</a>
                        <p class="product-card-subtitle">{{ \Illuminate\Support\Str::limit($product->summary, 70, '...') }}</p>
                            @if ($product->is_discounted)
                            @php
                                $discount = $product->discount;
                            @endphp
                            @if ($discount->discount_type == 'percentage')
                                <h3 class="product-card-price">{{ currency(($product->price / 100) * $discount->discount_value) }}</h3>
                            @else
                                <h3 class="product-card-price">{{ currency($product->price) }}</h3>
                            @endif
                            @else
                                <h3 class="product-card-price">{{ currency($product->price) }}</h3>
                            @endif
                        <div class="d-flex align-items-center flex-wrap gap-2">
                            <a href="{{ route('product', $product->slug) }}" class="btn bsb2-btn-skin">
                                <span>{{get_phrase('Shop Now!')}}</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="16" viewBox="0 0 17 16" fill="none">
                                    <path d="M1.07892 6.92357L0.0225108 6.92357L0.022511 9.03639L1.07892 9.03639L1.07892 6.92357ZM16.6257 8.72697C17.0382 8.31442 17.0382 7.64554 16.6257 7.23299L9.90275 0.51005C9.49019 0.0974972 8.82131 0.0974973 8.40876 0.51005C7.99621 0.922603 7.99621 1.59148 8.40876 2.00404L14.3847 7.97998L8.40876 13.9559C7.99621 14.3685 7.99621 15.0374 8.40876 15.4499C8.82131 15.8625 9.49019 15.8625 9.90275 15.4499L16.6257 8.72697ZM1.07892 7.97998L1.07892 9.03639L15.8787 9.03639L15.8787 7.97998L15.8787 6.92357L1.07892 6.92357L1.07892 7.97998Z" fill="white"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
           
        </div>
    </div>
</section>
<!-- Best Sellers Area End -->

<!-- Why Choose Us? Area Start -->
<section class="section-mb">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="why-choose-title-area">
                    <p class="bs-title-badge mx-auto mb-26px wow animate__fadeInUp" data-wow-delay=".1s">{{get_phrase('Why Choose Us?')}}</p>
                    <h2 class="section-title text-center max-w-898px mx-auto mb-14px wow animate__fadeInUp" data-wow-delay=".2s">{{get_phrase('What Sets Us Apart?')}}</h2>
                    <p class="section-subtitle text-center max-w-580px mx-auto why-choose-subtitle wow animate__fadeInUp" data-wow-delay=".3s">{{get_phrase('Quality craftsmanship, eco-conscious values, and design that blends function with fashion.')}}</p>
                    <div class="d-flex align-items-center justify-content-center flex-wrap gap-12px wow animate__fadeInUp" data-wow-delay=".4s">
                        <a href="{{route('all_products')}}" class="btn bs-btn-skin">
                            <span>{{get_phrase('Shop Now!')}}</span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="20" viewBox="0 0 22 20" fill="none">
                                <path d="M1.77997 8.65667L0.436635 8.65667L0.436635 11.3433L1.77997 11.3433L1.77997 8.65667ZM21.5365 10.9499C22.0611 10.4253 22.0611 9.57472 21.5365 9.05012L12.9876 0.501199C12.463 -0.023406 11.6124 -0.0234059 11.0878 0.501199C10.5632 1.0258 10.5632 1.87635 11.0878 2.40096L18.6869 10L11.0878 17.599C10.5632 18.1236 10.5632 18.9742 11.0878 19.4988C11.6124 20.0234 12.463 20.0234 12.9876 19.4988L21.5365 10.9499ZM1.77997 10L1.77997 11.3433L20.5866 11.3433L20.5866 10L20.5866 8.65667L1.77997 8.65667L1.77997 10Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="row g-3 justify-content-center wow animate__fadeInUp" data-wow-delay=".1s">
            <div class="col-md-6 col-lg-6 col-xl-4">
                <div class="why-choose1-card">
                    <img class="why-choose-banner" src="{{ asset('assets/frontend/bags/images/why-choose-banner1.webp') }}" alt="banner">
                    <div class="why-choose-content">
                        <div class="why-choose-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="65" height="58" viewBox="0 0 65 58" fill="none">
                                <path d="M13.963 56.9998C16.8267 56.9998 19.1481 54.6783 19.1481 51.8146C19.1481 48.9509 16.8267 46.6294 13.963 46.6294C11.0993 46.6294 8.77777 48.9509 8.77777 51.8146C8.77777 54.6783 11.0993 56.9998 13.963 56.9998Z" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M50.5185 56.9998C53.3822 56.9998 55.7037 54.6783 55.7037 51.8146C55.7037 48.9509 53.3822 46.6294 50.5185 46.6294C47.6548 46.6294 45.3333 48.9509 45.3333 51.8146C45.3333 54.6783 47.6548 56.9998 50.5185 56.9998Z" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M45.3333 51.8149H19.1481" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M8.77778 51.815H1V38.8521H63.4815V51.815H55.7037" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M34.9344 14.0928H42.7407V38.852H1V14.0928H8.67667" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M17.1763 14.0948L20.5328 17.4513L26.2778 11.7065" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M21.8704 26.7963C28.9938 26.7963 34.7685 21.0216 34.7685 13.8981C34.7685 6.7747 28.9938 1 21.8704 1C14.7469 1 8.97223 6.7747 8.97223 13.8981C8.97223 21.0216 14.7469 26.7963 21.8704 26.7963Z" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M63.4815 38.8518H42.7407V24.2036H54.4074L63.4815 38.8518Z" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M50.5185 33.6533V38.8516" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <h4 class="why-choose-title">{{get_phrase('Free shipping on all orders')}}</h4>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-4">
                <div class="w-100 h-100">
                    <div class="why-choose2-card mb-3">
                        <img class="why-choose-banner" src="{{ asset('assets/frontend/bags/images/why-choose-banner2.webp') }}" alt="banner">
                        <div class="why-choose-content">
                            <div class="why-choose-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56" fill="none">
                                    <mask id="mask0_44_810" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="56" height="56">
                                        <path d="M55 55V1H1V55H55Z" fill="white" stroke="white" stroke-width="2"/>
                                    </mask>
                                    <g mask="url(#mask0_44_810)">
                                        <path d="M44.4063 45.3906C42.5941 45.3906 41.125 43.9215 41.125 42.1094V28.9844C41.125 27.1722 42.5941 25.7031 44.4063 25.7031C46.2184 25.7031 47.6875 27.1722 47.6875 28.9844V42.1094C47.6875 43.9215 46.2184 45.3906 44.4063 45.3906Z" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M11.5938 45.3906C13.4059 45.3906 14.875 43.9215 14.875 42.1094V28.9844C14.875 27.1722 13.4059 25.7031 11.5938 25.7031C9.78163 25.7031 8.3125 27.1722 8.3125 28.9844V42.1094C8.3125 43.9215 9.78163 45.3906 11.5938 45.3906Z" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M3.9375 29.1851V25.7029C3.9375 12.4136 14.7106 1.64039 28 1.64039C41.2894 1.64039 52.0625 12.4136 52.0625 25.7029V29.1851" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M50.9688 42.1094H47.6875V28.9844H50.9688C52.7809 28.9844 54.25 30.4535 54.25 32.2656V38.8281C54.25 40.6402 52.7809 42.1094 50.9688 42.1094Z" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M5.03125 42.1094H8.3125V28.9844H5.03125C3.21913 28.9844 1.75 30.4535 1.75 32.2656V38.8281C1.75 40.6402 3.21913 42.1094 5.03125 42.1094Z" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M28 51.0781C28 52.8902 26.5309 54.3594 24.7188 54.3594C22.9066 54.3594 21.4375 52.8902 21.4375 51.0781C21.4375 49.266 22.9066 47.7969 24.7188 47.7969C26.5309 47.7969 28 49.266 28 51.0781Z" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M11.5938 45.3906C11.5938 48.5318 14.1401 51.0781 17.2813 51.0781H21.4375" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M37.5897 19.6419H29.3478C29.3478 19.6419 33.7115 11.732 34.4316 10.8485C35.1597 9.95509 35.8494 10.5123 35.915 11.3003C35.9807 12.0885 35.8823 23.5156 35.8823 23.5156" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M26.3952 23.4859C26.3952 23.4859 20.132 23.5647 19.8353 23.4657C19.5386 23.3668 20.3109 22.8444 24.4174 16.9772C25.1842 15.8815 25.6064 14.9571 25.786 14.1826L25.8497 13.6846C25.8497 11.8654 24.3748 10.3906 22.5556 10.3906C20.9548 10.3906 19.6208 11.5324 19.3235 13.0461" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    </g>
                                </svg>
                            </div>
                            <h4 class="why-choose-title">{{get_phrase('24/7 customer support')}}</h4>
                        </div>
                    </div>
                    <div class="why-choose3-card">
                        <p class="why-choose-badge mx-auto">{{get_phrase('Why Choose Us?')}}</p>
                        <h3 class="why-choose3-title">{{get_phrase('Unrivaled Quality, Inspired by You!!')}}</h3>
                        <p class="why-choose3-subtitle">{{get_phrase('Quality craftsmanship, eco-conscious values, and design that blends function with fashion.')}}</p>
                        <div class="text-center">
                            <a href="{{route('all_products')}}" class="btn bs-btn-white">
                                <span>{{get_phrase('Explore')}}</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="17" viewBox="0 0 18 17" fill="none">
                                    <path d="M2 7.59594L0.943592 7.59594L0.943593 9.70875L2 9.70875L2 7.59594ZM17.5468 9.39934C17.9593 8.98678 17.9593 8.3179 17.5468 7.90535L10.8238 1.18241C10.4113 0.76986 9.74239 0.769861 9.32984 1.18241C8.91729 1.59497 8.91729 2.26385 9.32984 2.6764L15.3058 8.65234L9.32984 14.6283C8.91729 15.0408 8.91729 15.7097 9.32984 16.1223C9.7424 16.5348 10.4113 16.5348 10.8238 16.1223L17.5468 9.39934ZM2 8.65234L2 9.70875L16.7998 9.70875L16.7998 8.65234L16.7998 7.59593L2 7.59594L2 8.65234Z" fill="black"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-4">
                <div class="why-choose1-card">
                    <img class="why-choose-banner" src="{{ asset('assets/frontend/bags/images/why-choose-banner3.webp') }}" alt="banner">
                    <div class="why-choose-content">
                        <div class="why-choose-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56" fill="none">
                                <mask id="mask0_44_716" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="56" height="56">
                                    <path d="M0 0H56V56H0V0Z" fill="white"/>
                                </mask>
                                <g mask="url(#mask0_44_716)">
                                    <path d="M11.5938 18.0469C11.5938 8.98592 18.939 1.64062 28 1.64062C37.061 1.64062 44.4063 8.98592 44.4063 18.0469C44.4063 27.1078 37.061 34.4531 28 34.4531C18.939 34.4531 11.5938 27.1078 11.5938 18.0469Z" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M19.7969 12.5781C19.7969 11.6721 20.5314 10.9375 21.4375 10.9375C22.3436 10.9375 23.0781 11.6721 23.0781 12.5781C23.0781 13.4842 22.3436 14.2188 21.4375 14.2188C20.5314 14.2188 19.7969 13.4842 19.7969 12.5781Z" fill="white"/>
                                    <path d="M36.2031 12.5781C36.2031 11.6721 35.4686 10.9375 34.5625 10.9375C33.6564 10.9375 32.9219 11.6721 32.9219 12.5781C32.9219 13.4842 33.6564 14.2188 34.5625 14.2188C35.4686 14.2188 36.2031 13.4842 36.2031 12.5781Z" fill="white"/>
                                    <path d="M34.5625 20.2344C34.5625 23.8587 31.6244 26.7969 28 26.7969C24.3756 26.7969 21.4375 23.8587 21.4375 20.2344" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M28 41.2344L30.1322 45.5548L34.9002 46.2477L31.4501 49.6106L32.2645 54.3594L28 52.1173L23.7355 54.3594L24.5499 49.6106L21.0997 46.2477L25.8677 45.5548L28 41.2344Z" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M47.4591 41.2344L49.5914 45.5548L54.3593 46.2477L50.9092 49.6106L51.7236 54.3594L47.4591 52.1173L43.1946 54.3594L44.009 49.6106L40.5588 46.2477L45.3268 45.5548L47.4591 41.2344Z" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M8.54088 41.2344L6.40861 45.5548L1.64062 46.2477L5.09075 49.6106L4.27634 54.3594L8.54088 52.1173L12.8054 54.3594L11.991 49.6106L15.4411 46.2477L10.6731 45.5548L8.54088 41.2344Z" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                </g>
                            </svg>
                        </div>
                        <h4 class="why-choose-title">{{get_phrase('100% satisfaction guarantee')}}</h4>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Why Choose Us? Area End -->

<!-- Lifestyle That Represent Area Start -->
<section class="section-mb overflow-hidden">
    <div class="container">
        <div class="row g-4 justify-content-center align-items-center">
            <div class="col-md-10 col-lg-6">
                <div class="pe-lg-4">
                    <div class="lifestyle-banner-main wow animate__fadeInLeft" data-wow-delay=".1s">
                        <div>
                            <div class="lifestyle-bag-wrap1 mb-12px">
                                <img class="bag" src="{{ asset('assets/frontend/bags/images/lifestyle-bag1.webp') }}" alt="bag">
                            </div>
                            <div class="lifestyle-bag-wrap2">
                                <img class="bag" src="{{ asset('assets/frontend/bags/images/lifestyle-bag2.webp') }}" alt="bag">
                            </div>
                        </div>
                        <div>
                            <div class="lifestyle-bag-wrap3 mb-12px">
                                <img class="bag" src="{{ asset('assets/frontend/bags/images/lifestyle-bag3.webp') }}" alt="bag">
                            </div>
                            <div class="lifestyle-bag-wrap4">
                                <img class="bag" src="{{ asset('assets/frontend/bags/images/lifestyle-bag4.webp') }}" alt="bag">
                            </div>
                        </div>
                        <div>
                            <div class="lifestyle-bag-wrap5">
                                <img class="bag" src="{{ asset('assets/frontend/bags/images/lifestyle-bag5.webp') }}" alt="bag">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-10 col-lg-6">
                <div class="ps-lg-4">
                    <p class="bs-title-badge mb-26px wow animate__fadeInUp" data-wow-delay=".1s">{{get_phrase('Lifestyle That Represent')}}</p>
                    <h2 class="section-title mb-18px wow animate__fadeInUp" data-wow-delay=".2s">{{get_phrase('Style That Moves With You!')}}</h2>
                    <p class="section-subtitle lifestyle-section-subtitle wow animate__fadeInUp" data-wow-delay=".3s">{{get_phrase('Whether it’s the office, gym, or airport—our bags are made to match your pace.')}}</p>
                    <ul class="mb-40px d-grid gap-28px wow animate__fadeInUp" data-wow-delay=".4s">
                        <li class="iconbox-text-list-item">
                            <div class="circle-iconbox">
                                <svg width="34" height="34" viewBox="0 0 34 34" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M34.0002 5.24612C34.0002 2.35338 31.6468 0 28.7541 0C26.1788 0 24.0324 1.86589 23.5921 4.31643H17.0001C16.7366 4.31643 16.4839 4.42082 16.2972 4.60669L0.293104 20.5443C-0.0970364 20.9329 -0.0978997 21.565 0.291709 21.9544L12.0457 33.7084C12.435 34.0976 13.0671 34.0972 13.4559 33.707L29.3935 17.703C29.5794 17.5163 29.6838 17.2636 29.6838 17.0001V10.408C32.1343 9.96776 34.0002 7.82143 34.0002 5.24612ZM27.6916 16.5887L12.7486 31.5939L2.40617 21.2516L17.4115 6.30862H23.6157C23.8195 7.30459 24.309 8.22013 25.0445 8.95565C25.4335 9.3446 26.0641 9.34453 26.4532 8.95572C26.8422 8.56671 26.8422 7.93605 26.4533 7.54697C26.0984 7.1921 25.8362 6.76948 25.6775 6.30862H27.6916V16.5887H27.6916ZM29.6838 8.36397V5.31252C29.6838 4.76241 29.2378 4.31643 28.6877 4.31643H25.6362C26.0373 2.97388 27.2829 1.9922 28.7541 1.9922C30.5483 1.9922 32.008 3.45188 32.008 5.24612C32.008 6.71729 31.0263 7.96294 29.6838 8.36397Z" fill="white"/>
                                    <path d="M10.2667 18.9524C9.87779 18.5634 9.24705 18.5634 8.85804 18.9524C8.46903 19.3413 8.46903 19.972 8.85804 20.361L13.6393 25.1423C14.0283 25.5313 14.659 25.5313 15.048 25.1423C15.437 24.7534 15.437 24.1226 15.048 23.7336L10.2667 18.9524Z" fill="white"/>
                                    <path d="M12.923 16.2961C12.534 15.9072 11.9033 15.9072 11.5143 16.2961C11.1253 16.685 11.1253 17.3158 11.5143 17.7048L16.2956 22.4861C16.6846 22.8751 17.3153 22.8751 17.7043 22.4861C18.0933 22.0971 18.0933 21.4664 17.7043 21.0774L12.923 16.2961Z" fill="white"/>
                                    <path d="M15.5795 13.6399C15.1905 13.2509 14.5598 13.2509 14.1708 13.6399C13.7818 14.0288 13.7818 14.6595 14.1708 15.0485L18.9521 19.8298C19.3411 20.2188 19.9718 20.2188 20.3608 19.8298C20.7498 19.4409 20.7498 18.8101 20.3608 18.4211L15.5795 13.6399Z" fill="white"/>
                                </svg>
                            </div>
                            <p class="iconbox-text-list-title">{{get_phrase('Work-Ready Style')}}</p>
                        </li>
                        <li class="iconbox-text-list-item">
                            <div class="circle-iconbox">
                                <svg width="34" height="34" viewBox="0 0 34 34" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <mask id="mask0_45_857" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="34" height="34">
                                    <path d="M0 0H34V34H0V0Z" fill="white"/>
                                    </mask>
                                    <g mask="url(#mask0_45_857)">
                                    <path d="M16.9999 21.5266L8.54031 29.9861L0.996094 33.0039L4.01366 25.4594L12.4732 16.9999" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M17 12.4734L28.4773 0.996161L33.0039 5.52268L21.5265 17" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    </g>
                                    <path d="M28.4773 10.0493L23.9507 5.5228" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M4.24011 25.686L8.314 29.7598" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    <mask id="mask1_45_857" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="34" height="34">
                                    <path d="M0 0H34V34H0V0Z" fill="white"/>
                                    </mask>
                                    <g mask="url(#mask1_45_857)">
                                    <path d="M32.3798 29.3624C33.5165 26.983 33.1007 24.0475 31.1297 22.0767C29.4546 20.4015 27.0825 19.8505 24.947 20.4206L13.5798 9.05313C14.1495 6.9179 13.5985 4.54554 11.9233 2.87024C9.95251 0.89944 7.01702 0.483604 4.63769 1.62001L8.90562 5.88795L5.88792 8.90564L1.61985 4.63778C0.483578 7.01725 0.899348 9.95274 2.87029 11.9234C4.54538 13.5986 6.91755 14.1495 9.05297 13.5798L20.4206 24.9471C19.8506 27.0823 20.4014 29.4545 22.0764 31.1297C24.0475 33.1006 26.9829 33.5165 29.3624 32.38L25.0943 28.1121L28.112 25.0944L32.3798 29.3624Z" stroke="white" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    </g>
                                </svg>
                            </div>
                            <p class="iconbox-text-list-title">{{get_phrase('Effortless Everyday Versatility')}}</p>
                        </li>
                    </ul>
                    <div class="d-flex align-items-center flex-wrap gap-12px wow animate__fadeInUp" data-wow-delay=".5s">
                        <a href="{{route('all_products')}}" class="btn bs-btn-skin">
                            <span>{{get_phrase('Shop Now!')}}</span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="20" viewBox="0 0 22 20" fill="none">
                                <path d="M1.77997 8.65667L0.436635 8.65667L0.436635 11.3433L1.77997 11.3433L1.77997 8.65667ZM21.5365 10.9499C22.0611 10.4253 22.0611 9.57472 21.5365 9.05012L12.9876 0.501199C12.463 -0.023406 11.6124 -0.0234059 11.0878 0.501199C10.5632 1.0258 10.5632 1.87635 11.0878 2.40096L18.6869 10L11.0878 17.599C10.5632 18.1236 10.5632 18.9742 11.0878 19.4988C11.6124 20.0234 12.463 20.0234 12.9876 19.4988L21.5365 10.9499ZM1.77997 10L1.77997 11.3433L20.5866 11.3433L20.5866 10L20.5866 8.65667L1.77997 8.65667L1.77997 10Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Lifestyle That Represent Area End -->

<!-- Our Blogs Area Start -->
<section class="section-mb">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div>
                    <p class="bs-title-badge mb-26px wow animate__fadeInUp" data-wow-delay=".1s">{{get_phrase('Our Blogs')}}</p>
                    <div class="blogs-section-title-area">
                        <div>
                            <h2 class="section-title blogs-section-title wow animate__fadeInUp" data-wow-delay=".2s">{{get_phrase('Tips, Stories & Bag Wisdom!!')}}</h2>
                        </div>
                        <div class="blogs-section-title-right">
                            <p class="section-subtitle mb-30px wow animate__fadeInUp" data-wow-delay=".3s">{{get_phrase('Dive into packing tips, travel stories, and style advice from our expert writers.')}}</p>
                            <a href="{{route('blog')}}" class="btn bs-btn-skin wow animate__fadeInUp" data-wow-delay=".4s">
                                <span>{{get_phrase('Read More')}}</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="20" viewBox="0 0 22 20" fill="none">
                                    <path d="M1.77997 8.65667L0.436635 8.65667L0.436635 11.3433L1.77997 11.3433L1.77997 8.65667ZM21.5365 10.9499C22.0611 10.4253 22.0611 9.57472 21.5365 9.05012L12.9876 0.501199C12.463 -0.023406 11.6124 -0.0234059 11.0878 0.501199C10.5632 1.0258 10.5632 1.87635 11.0878 2.40096L18.6869 10L11.0878 17.599C10.5632 18.1236 10.5632 18.9742 11.0878 19.4988C11.6124 20.0234 12.463 20.0234 12.9876 19.4988L21.5365 10.9499ZM1.77997 10L1.77997 11.3433L20.5866 11.3433L20.5866 10L20.5866 8.65667L1.77997 8.65667L1.77997 10Z" fill="white"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row gx-22px gy-4 justify-content-center wow animate__fadeInUp" data-wow-delay=".1s">
            @foreach($blogs->take(2) as $key=>$blog)
            
            <div class="col-md-10 col-lg-6">
                <a href="{{ route('blog_details', ['slug' => $blog->slug]) }}" class="bs-blog-card">
                    <div class="blog-card-banner">
                        <img class="banner" src="{{ get_image($blog->thumbnail) }}" alt="banner">
                        <h2 class="blog-number">0{{++$key}}</h2>
                    </div>
                    <div class="blog-card-body">
                        <h3 class="blog-card-title">{{ $blog->title }}</h3>
                        <p class="blog-card-subtitle">{{ \Illuminate\Support\Str::limit($blog->summary, 80, '...') }}</p>
                        <div class="d-flex align-items-center column-gap-14px row-gap-2 flex-wrap">
                            <div class="date-comment-list-item">
                                <svg width="31" height="32" viewBox="0 0 31 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M20 4.16667V1M20 4.16667V7.33333M20 4.16667H12.875M1 13.6667V27.9167C1 29.6656 2.41776 31.0833 4.16667 31.0833H26.3333C28.0823 31.0833 29.5 29.6656 29.5 27.9167V13.6667H1Z" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M1 13.668V7.33464C1 5.58573 2.41776 4.16797 4.16667 4.16797H7.33333" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M7.33325 1V7.33333" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M29.5001 13.668V7.33464C29.5001 5.58573 28.0824 4.16797 26.3334 4.16797H25.5417" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                                <p>{{ $blog->created_at->format('d M, Y') }}</p>
                            </div>
                           
                        </div>
                    </div>
                </a>
            </div>
            @endforeach
        </div>
    </div>
</section>
<!-- Our Blogs Area End -->

<!-- Testimonial Area Start -->
<section class="testimonial-section section-mb">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="mb-40px">
                    <p class="bs-title-badge mx-auto mb-26px wow animate__fadeInUp" data-wow-delay=".1s">{{get_phrase('Testimonials')}}</p>
                    <h2 class="section-title text-center max-w-898px mx-auto mb-14px wow animate__fadeInUp" data-wow-delay=".2s">{{get_phrase('What Our Customers Are Saying')}}</h2>
                    <p class="section-subtitle text-center testimonial-section-subtitle wow animate__fadeInUp" data-wow-delay=".3s">{{get_phrase('Real Reviews. Real Journeys.  Join thousands who trust our bags for work, travel, and everyday life.')}}</p>
                    <div class="text-center wow animate__fadeInUp" data-wow-delay=".4s">
                        <a href="javascript:;" class="btn bs-btn-outline-dark px-20px">{{get_phrase('Join Our Happy Customers')}}</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            <div class="col-lg-10 col-xl-12">
                <div class="testimonial-wrap-main">
                    <div class="large-testimonial-wrap wow animate__fadeInUp" data-wow-delay=".1s">
                        <div class="swiper-container large-testimonial-view position-relative overflow-hidden">
                            <div class="swiper-wrapper">
                                @foreach($reviews as $review)
                                <div class="swiper-slide">
                                    <div class="single-testimonial">
                                        <div class="testimonial-left-content">
                                           
                                            <div class="testimonial-comment-wrap">
                                                <p class="testimonial-comment">“{{$review->comment}}”</p>
                                            </div>
                                            <div>
                                                <h5 class="ts-user-name">{{ $review->user->name }}</h5>
                                                <p class="ts-user-role">{{ $review->created_at->format('F j, Y') }}</p>
                                            </div>
                                        </div>
                                        <div class="testimonial-user-profile">
                                            <div class="testimonial-quote-shape">
                                                <svg width="37" height="32" viewBox="0 0 37 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M0.104206 0.724829H14.2357C15.6164 5.2816 16.3067 10.0041 16.3067 14.8923C16.3067 19.8633 15.0479 23.7987 12.5302 26.6984C9.9313 29.6811 6.11417 31.1724 1.0788 31.1724V24.2129C5.13958 24.2129 7.16997 21.686 7.16997 16.6321L7.16997 14.2709H0.104206V0.724829ZM20.6924 0.724829L34.8239 0.724829C36.2046 5.2816 36.8949 10.0041 36.8949 14.8923C36.8949 19.8633 35.6361 23.7987 33.1184 26.6984C30.5195 29.6811 26.7023 31.1724 21.667 31.1724V24.2129C25.7277 24.2129 27.7581 21.686 27.7581 16.6321V14.2709L20.6924 14.2709V0.724829Z" fill="black"/>
                                                </svg>
                                            </div>
                                            <img class="profile" src="{{ get_image($review->user->photo) }}" alt="profile">
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    <div class="small-testimonial-wrap wow animate__fadeInUp" data-wow-delay=".2s">
                        <div class="swiper-container small-testimonial-view position-relative overflow-hidden">
                            <div class="swiper-wrapper">
                                @foreach($reviews as $review)
                                <div class="swiper-slide">
                                    <div class="small-testimonial">
                                        <div class="sm-testimonial-profile">
                                            <img class="profile" src="{{ get_image($review->user->photo) }}" alt="profile">
                                        </div>
                                        <div>
                                            <h4 class="sm-ts-user-name">{{ $review->user->name }}</h4>
                                            <p class="sm-ts-user-role">{{ $review->created_at->format('F j, Y') }}</p>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                            <div class="ts-slider-nav">
                                <!-- Add Arrows -->
                                <div class="swiper-button-prev">
                                    <svg width="23" height="21" viewBox="0 0 23 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M21.0725 10.5913L1.94208 10.5913M1.94208 10.5913L10.9759 19.3594M1.94208 10.5913L10.9759 1.82315" stroke="black" stroke-width="1.99275" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div class="swiper-button-next">
                                    <svg width="22" height="21" viewBox="0 0 22 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.72461 10.5914H20.855M20.855 10.5914L11.8212 1.82324M20.855 10.5914L11.8212 19.3595" stroke="black" stroke-width="1.99275" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Testimonial Area End -->

<!-- Inspirational Content Area Start -->
<section class="section-mb">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="inspirational-title-area">
                    <p class="bs-title-badge mx-auto mb-26px wow animate__fadeInUp" data-wow-delay=".1s">{{get_phrase('Inspirational Content')}}</p>
                    <h2 class="section-title text-center mb-12px wow animate__fadeInUp" data-wow-delay=".2s">{{get_phrase('Real People. Real Adventures.')}}</h2>
                    <p class="section-subtitle text-center inspirational-section-subtitle wow animate__fadeInUp" data-wow-delay=".3s">{{get_phrase('See how our bags fit into your world. Snapshots from customers around the globe.')}}</p>
                    <div class="d-flex align-items-center justify-content-center flex-wrap gap-12px wow animate__fadeInUp" data-wow-delay=".4s">
                        <a href="{{route('all_products')}}" class="btn bs-btn-skin">
                            <span>{{get_phrase('Shop Now!')}}</span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="20" viewBox="0 0 22 20" fill="none">
                                <path d="M1.77997 8.65667L0.436635 8.65667L0.436635 11.3433L1.77997 11.3433L1.77997 8.65667ZM21.5365 10.9499C22.0611 10.4253 22.0611 9.57472 21.5365 9.05012L12.9876 0.501199C12.463 -0.023406 11.6124 -0.0234059 11.0878 0.501199C10.5632 1.0258 10.5632 1.87635 11.0878 2.40096L18.6869 10L11.0878 17.599C10.5632 18.1236 10.5632 18.9742 11.0878 19.4988C11.6124 20.0234 12.463 20.0234 12.9876 19.4988L21.5365 10.9499ZM1.77997 10L1.77997 11.3433L20.5866 11.3433L20.5866 10L20.5866 8.65667L1.77997 8.65667L1.77997 10Z" fill="white"/>
                            </svg>
                        </a>
                       
                    </div>
                </div>
            </div>
        </div>
        <div class="row wow animate__fadeInUp" data-wow-delay=".1s">
            <div class="col-12">
                <div class="inspirational-gallery-main">
                    <div>
                        <div class="inspirational-img-wrap1">
                            <img class="image" src="{{ asset('assets/frontend/bags/images/inspirational-image1.webp') }}" alt="inspirational">
                        </div>
                    </div>
                    <div>
                        <div class="inspirational-img-wrap2 mb-12px">
                            <img class="image" src="{{ asset('assets/frontend/bags/images/inspirational-image2.webp') }}" alt="inspirational">
                        </div>
                        <div class="inspirational-img-wrap3">
                            <img class="image" src="{{ asset('assets/frontend/bags/images/inspirational-image3.webp') }}" alt="inspirational">
                        </div>
                    </div>
                    <div>
                        <div class="inspirational-img-wrap4 mb-12px">
                            <img class="image" src="{{ asset('assets/frontend/bags/images/inspirational-image4.webp') }}" alt="inspirational">
                        </div>
                        <div class="inspirational-img-wrap5">
                            <img class="image" src="{{ asset('assets/frontend/bags/images/inspirational-image5.webp') }}" alt="inspirational">
                        </div>
                    </div>
                    <div>
                        <div class="inspirational-img-wrap2 mb-12px">
                            <img class="image" src="{{ asset('assets/frontend/bags/images/inspirational-image6.webp') }}" alt="inspirational">
                        </div>
                        <div class="inspirational-img-wrap3">
                            <img class="image" src="{{ asset('assets/frontend/bags/images/inspirational-image7.webp') }}" alt="inspirational">
                        </div>
                    </div>
                    <div>
                        <div class="inspirational-img-wrap1">
                            <img class="image" src="{{ asset('assets/frontend/bags/images/inspirational-image8.webp') }}" alt="inspirational">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Inspirational Content Area End -->