@php
    $current_route = Route::currentRouteName();
@endphp

<div class="offcanvas-lg offcanvas-end up-sidebar-offcanvas" tabindex="-1" id="up-sidebar-offcanvas" aria-labelledby="up-sidebar-offcanvasLabel">
    <div class="offcanvas-header">
        <div class="up-sidebar-header">
            <div class="circle-image-50px">
                <img src="{{ get_image(auth()->user()->photo) }}" alt="user-image">
            </div>
            <div>
                <h4 class="in-title-16px fw-medium mb-2">{{ auth()->user()->name }}</h4>
                <p class="in-subtitle-14px text-break lh-1 fw-normal">{{ auth()->user()->email }}</p>
            </div>
        </div>
      <button type="button" class="btn-close" data-bs-dismiss="offcanvas" data-bs-target="#up-sidebar-offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <div class="up-sidebar w-100">
            <div class="d-none d-lg-block">
                <div class="up-sidebar-header">
                    <div class="circle-image-50px">
                        <img src="{{ get_image(auth()->user()->photo) }}" alt="user-image">
                    </div>
                    <div>
                        <h4 class="in-title-16px fw-medium mb-2">{{ auth()->user()->name }}</h4>
                        <p class="in-subtitle-14px text-break lh-1 fw-normal">{{ auth()->user()->email }}</p>
                    </div>
                </div>
            </div>
            <div class="mb-10px">
                <h3 class="in-title-14px mb-10px up-sidebar-title">{{ get_phrase('My Customer Panel') }}</h3>
                <nav>
                    <ul class="sidebar-nav-ul">
                         <li class="sidebar-nav-item"><a href="{{ route('customer.orders') }}" class="sidebar-nav-link @if($current_route == 'customer.orders' || $current_route == 'customer.order') active @endif">
                            <span class="d-flex align-items-start gap-6px">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                    <path d="M14.1074 4.68749H15.1274C14.9849 4.48499 14.8349 4.29749 14.6774 4.10999L14.1074 4.68749Z" fill="#99A1B7"/>
                                    <path d="M13.89 3.31499C13.7025 3.15749 13.515 3.00749 13.3125 2.86499V3.88499L13.89 3.31499Z" fill="#99A1B7"/>
                                    <path d="M14.6851 4.11002L16.8976 1.89752C17.1151 1.68002 17.1151 1.32002 16.8976 1.10252C16.6801 0.885017 16.3201 0.885017 16.1026 1.10252L13.8901 3.31502C14.1751 3.56252 14.4376 3.83252 14.6851 4.11002Z" fill="#99A1B7"/>
                                    <path d="M13.3123 2.25C13.3123 1.9425 13.0573 1.6875 12.7498 1.6875C12.4498 1.6875 12.2098 1.9275 12.1948 2.22C12.5848 2.4075 12.9598 2.6175 13.3123 2.865V2.25Z" fill="#99A1B7"/>
                                    <path d="M16.3124 5.25C16.3124 4.9425 16.0574 4.6875 15.7499 4.6875H15.1274C15.3749 5.04 15.5924 5.415 15.7724 5.805C16.0724 5.79 16.3124 5.55 16.3124 5.25Z" fill="#99A1B7"/>
                                    <path d="M9.5625 11.0625H9.7875C10.08 11.0625 10.3125 10.8 10.3125 10.4775C10.3125 10.0725 10.2 10.0125 9.945 9.92248L9.5625 9.78748V11.0625Z" fill="#99A1B7"/>
                                    <path d="M15.78 5.805C15.7725 5.805 15.765 5.8125 15.75 5.8125H12.75C12.675 5.8125 12.6075 5.7975 12.5325 5.7675C12.3975 5.7075 12.285 5.6025 12.225 5.46C12.2025 5.3925 12.1875 5.325 12.1875 5.25V2.25C12.1875 2.2425 12.195 2.235 12.195 2.22C11.22 1.7625 10.14 1.5 9 1.5C4.86 1.5 1.5 4.86 1.5 9C1.5 13.14 4.86 16.5 9 16.5C13.14 16.5 16.5 13.14 16.5 9C16.5 7.86 16.2375 6.78 15.78 5.805ZM10.3125 8.865C10.7925 9.03 11.4375 9.3825 11.4375 10.485C11.4375 11.4225 10.695 12.195 9.7875 12.195H9.5625V12.3825C9.5625 12.69 9.3075 12.945 9 12.945C8.6925 12.945 8.4375 12.69 8.4375 12.3825V12.195H8.3775C7.38 12.195 6.5625 11.355 6.5625 10.32C6.5625 10.005 6.8175 9.75 7.125 9.75C7.4325 9.75 7.6875 10.005 7.6875 10.3125C7.6875 10.725 7.995 11.0625 8.3775 11.0625H8.4375V9.3975L7.6875 9.135C7.2075 8.97 6.5625 8.6175 6.5625 7.515C6.5625 6.5775 7.305 5.805 8.2125 5.805H8.4375V5.625C8.4375 5.3175 8.6925 5.0625 9 5.0625C9.3075 5.0625 9.5625 5.3175 9.5625 5.625V5.8125H9.6225C10.62 5.8125 11.4375 6.6525 11.4375 7.6875C11.4375 7.995 11.1825 8.25 10.875 8.25C10.5675 8.25 10.3125 7.995 10.3125 7.6875C10.3125 7.275 10.005 6.9375 9.6225 6.9375H9.5625V8.6025L10.3125 8.865Z" fill="#99A1B7"/>
                                    <path d="M7.6875 7.5225C7.6875 7.9275 7.8 7.9875 8.055 8.0775L8.4375 8.2125V6.9375H8.2125C7.9275 6.9375 7.6875 7.2 7.6875 7.5225Z" fill="#99A1B7"/>
                                </svg>
                                <span class="mt-2px">{{ get_phrase('My Orders') }}</span>
                            </span>                                               
                        </a></li>
                        <li class="sidebar-nav-item"><a href="{{ route('customer.order.return_requests') }}" class="sidebar-nav-link @if($current_route == 'customer.order.return_requests' || $current_route == 'customer.order.return_requests') active @endif">
                            <span class="d-flex align-items-start gap-6px">
                               <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M16 2.25H8C5.582 2.25 4.25 3.582 4.25 6V21C4.25 21.268 4.39302 21.5149 4.62402 21.6479C4.74002 21.716 4.87 21.75 5 21.75C5.128 21.75 5.25707 21.717 5.37207 21.651L12 17.863L18.6279 21.65C18.8609 21.783 19.146 21.782 19.376 21.647C19.607 21.513 19.75 21.266 19.75 20.999V5.99902C19.75 3.58202 18.418 2.25 16 2.25ZM18.25 19.707L12.3721 16.349C12.1421 16.217 11.8579 16.217 11.6279 16.349L5.75 19.708V6C5.75 4.423 6.423 3.75 8 3.75H16C17.577 3.75 18.25 4.423 18.25 6V19.707ZM14.53 8.53003L13.0601 10L14.53 11.47C14.823 11.763 14.823 12.238 14.53 12.531C14.384 12.677 14.192 12.751 14 12.751C13.808 12.751 13.616 12.678 13.47 12.531L12 11.061L10.53 12.531C10.384 12.677 10.192 12.751 10 12.751C9.808 12.751 9.61597 12.678 9.46997 12.531C9.17697 12.238 9.17697 11.763 9.46997 11.47L10.9399 10L9.46997 8.53003C9.17697 8.23703 9.17697 7.76199 9.46997 7.46899C9.76297 7.17599 10.238 7.17599 10.531 7.46899L12.001 8.93896L13.4709 7.46899C13.7639 7.17599 14.239 7.17599 14.532 7.46899C14.825 7.76199 14.823 8.23703 14.53 8.53003Z" fill="#9AA2B7"/>
                                </svg>
                                <span class="mt-2px">{{ get_phrase('My Returns') }}</span>
                            </span>                                               
                        </a></li>
                        <li class="sidebar-nav-item"><a href="{{ route('customer.wishlist_items') }}" class="sidebar-nav-link @if($current_route == 'customer.wishlist_items') active @endif">
                            <span class="d-flex align-items-start gap-6px">
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M20.717 14.079C21.112 13.278 21.402 12.453 21.567 11.613C22.045 9.14598 21.567 6.74503 20.29 5.18903C19.257 3.92903 17.768 3.259 15.983 3.25C15.976 3.25 15.97 3.25 15.964 3.25C13.928 3.25 12.687 4.40898 12 5.39398C11.312 4.40798 10.072 3.25 8.03404 3.25C8.02804 3.25 8.021 3.25 8.015 3.25C6.235 3.259 4.74702 3.93 3.71202 5.19C2.43402 6.747 1.95499 9.148 2.43199 11.612C3.66099 17.969 11.3619 21.534 11.6889 21.683C11.7879 21.728 11.894 21.75 12 21.75C12.106 21.75 12.2099 21.728 12.3089 21.684C12.3429 21.668 13.061 21.342 14.083 20.72C14.891 21.355 15.896 21.75 17 21.75C19.619 21.75 21.75 19.619 21.75 17C21.75 15.893 21.354 14.887 20.717 14.079ZM12.0019 20.166C10.5979 19.451 4.85701 16.254 3.90501 11.328C3.51201 9.297 3.87393 7.35901 4.87193 6.14301C5.62493 5.22601 6.68495 4.75798 8.02195 4.75098C8.02595 4.75098 8.03004 4.75098 8.03404 4.75098C10.412 4.75098 11.2549 7.13003 11.2879 7.22803C11.3909 7.53303 11.6759 7.73801 11.9969 7.73901C11.9979 7.73901 11.999 7.73901 12.001 7.73901C12.321 7.73901 12.606 7.53398 12.711 7.22998C12.745 7.12898 13.588 4.75 15.964 4.75C15.968 4.75 15.9719 4.75 15.9759 4.75C17.3169 4.757 18.378 5.22499 19.13 6.14099C20.127 7.35499 20.487 9.29399 20.094 11.326C19.983 11.893 19.783 12.451 19.545 13.003C18.808 12.532 17.938 12.25 17.001 12.25C14.382 12.25 12.251 14.381 12.251 17C12.251 17.96 12.5419 18.851 13.0329 19.599C12.5999 19.852 12.2369 20.047 12.0019 20.166ZM17 20.25C15.208 20.25 13.75 18.792 13.75 17C13.75 15.208 15.208 13.75 17 13.75C18.792 13.75 20.25 15.208 20.25 17C20.25 18.792 18.792 20.25 17 20.25ZM18.78 15.636C19.073 15.929 19.073 16.404 18.78 16.697L17.113 18.364C16.972 18.504 16.782 18.583 16.583 18.583C16.384 18.583 16.193 18.504 16.053 18.363L15.22 17.53C14.927 17.237 14.927 16.762 15.22 16.469C15.513 16.177 15.988 16.176 16.281 16.469L16.584 16.772L17.7209 15.636C18.0129 15.344 18.487 15.344 18.78 15.636Z" fill="#9AA2B7"/>
                                    </svg>
                                <span class="mt-2px">{{ get_phrase('My Wishlist') }}</span>
                            </span>                                               
                        </a></li>
                        <li class="sidebar-nav-item @if($current_route == 'customer.cart_items') active @endif"><a href="{{ route('customer.cart_items') }}" class="sidebar-nav-link">
                            <span class="d-flex align-items-start gap-6px">
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M10.7679 14.5V17.5C10.7679 17.914 10.4319 18.25 10.0179 18.25C9.60394 18.25 9.26794 17.914 9.26794 17.5V14.5C9.26794 14.086 9.60394 13.75 10.0179 13.75C10.4319 13.75 10.7679 14.086 10.7679 14.5ZM14.0179 13.75C13.6039 13.75 13.2679 14.086 13.2679 14.5V17.5C13.2679 17.914 13.6039 18.25 14.0179 18.25C14.4319 18.25 14.7679 17.914 14.7679 17.5V14.5C14.7679 14.086 14.4319 13.75 14.0179 13.75ZM20.2271 11.448L19.535 18.373C19.308 20.645 18.088 21.75 15.804 21.75H8.23401C5.95001 21.75 4.72905 20.646 4.50305 18.373L3.81299 11.469C2.89199 11.024 2.25098 10.089 2.25098 8.99996C2.25098 7.48296 3.48398 6.24996 5.00098 6.24996H7.15796L9.35901 2.61196C9.57301 2.25796 10.032 2.14395 10.389 2.35895C10.743 2.57295 10.857 3.03496 10.642 3.38896L8.91101 6.25096H15.062L13.3571 3.38495C13.1451 3.02895 13.262 2.56895 13.618 2.35695C13.974 2.14395 14.434 2.26295 14.646 2.61795L16.808 6.25196H19C20.517 6.25196 21.75 7.48496 21.75 9.00196C21.75 10.073 21.1261 10.995 20.2271 11.448ZM3.75 8.99996C3.75 9.68896 4.311 10.25 5 10.25H19C19.689 10.25 20.25 9.68896 20.25 8.99996C20.25 8.31096 19.689 7.74996 19 7.74996H5C4.311 7.74996 3.75 8.31096 3.75 8.99996ZM18.6899 11.75H5.34705L5.99402 18.224C6.12602 19.538 6.52103 20.25 8.23303 20.25H15.803C17.506 20.25 17.913 19.507 18.042 18.224L18.6899 11.75Z" fill="#9AA2B7" fill-opacity="0.8"/>
                                    </svg>
                                <span class="mt-2px">{{ get_phrase('My Cart') }}</span>
                            </span>                                               
                        </a></li>
                        
                        <li class="sidebar-nav-item"><a href="{{ route('customer.profile') }}" class="sidebar-nav-link @if($current_route == 'customer.profile') active @endif">
                            <span class="d-flex align-items-start gap-6px">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                    <path d="M9 1.5C7.035 1.5 5.4375 3.0975 5.4375 5.0625C5.4375 6.99 6.945 8.55 8.91 8.6175C8.97 8.61 9.03 8.61 9.075 8.6175C9.09 8.6175 9.0975 8.6175 9.1125 8.6175C9.12 8.6175 9.12 8.6175 9.1275 8.6175C11.0475 8.55 12.555 6.99 12.5625 5.0625C12.5625 3.0975 10.965 1.5 9 1.5Z" fill="#99A1B7"/>
                                    <path d="M12.8102 10.6125C10.7177 9.21753 7.30521 9.21753 5.19771 10.6125C4.24521 11.25 3.72021 12.1125 3.72021 13.035C3.72021 13.9575 4.24521 14.8125 5.19021 15.4425C6.24021 16.1475 7.62021 16.5 9.00021 16.5C10.3802 16.5 11.7602 16.1475 12.8102 15.4425C13.7552 14.805 14.2802 13.95 14.2802 13.02C14.2727 12.0975 13.7552 11.2425 12.8102 10.6125Z" fill="#99A1B7"/>
                                </svg>
                                <span class="mt-2px">{{ get_phrase('My Profile') }}</span>
                            </span>                                               
                        </a></li>
                        <li class="sidebar-nav-item">
                            <a href="{{ route('customer.shipping_addresses') }}" class="sidebar-nav-link @if($current_route == 'customer.shipping_addresses') active @endif">
                                <span class="d-flex align-items-start gap-6px">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                        <path d="M14.0473 11.0026L10.9348 14.1151C10.8148 14.2351 10.7023 14.4676 10.6723 14.6326L10.4998 15.8251C10.4398 16.2526 10.7398 16.5601 11.1673 16.4926L12.3598 16.3201C12.5248 16.2976 12.7573 16.1776 12.8773 16.0576L15.9898 12.9451C16.5223 12.4126 16.7773 11.7826 15.9898 10.9951C15.2098 10.2151 14.5873 10.4626 14.0473 11.0026Z" fill="#99A1B7"/>
                                        <path d="M13.605 11.4449C13.8675 12.3899 14.61 13.1249 15.555 13.3949L13.605 11.4449Z" fill="#99A1B7"/>
                                        <path d="M1.52232 10.9725C1.52232 10.995 1.50732 11.025 1.50732 11.0475C2.19732 12.4275 3.32232 13.56 4.70232 14.2425C4.72482 14.2425 4.75482 14.2275 4.77732 14.2275C4.52232 13.3575 4.32732 12.465 4.18482 11.5725C3.28482 11.4225 2.39232 11.2275 1.52232 10.9725Z" fill="#99A1B7"/>
                                        <path d="M14.3026 4.82246C13.5976 3.34496 12.4051 2.15246 10.9351 1.45496C11.2051 2.34746 11.4301 3.26246 11.5801 4.17746C12.4951 4.32746 13.4101 4.54496 14.3026 4.82246Z" fill="#99A1B7"/>
                                        <path d="M1.44727 4.82251C2.34727 4.55251 3.26227 4.32751 4.17727 4.17751C4.32727 3.28501 4.51477 2.40001 4.76977 1.53001C4.74727 1.53001 4.71727 1.51501 4.69477 1.51501C3.28477 2.21251 2.13727 3.39001 1.44727 4.82251Z" fill="#99A1B7"/>
                                        <path d="M10.3648 4.02C10.1848 3.045 9.95977 2.07 9.63727 1.125C9.62227 1.0725 9.62227 1.0275 9.61477 0.9675C9.05977 0.8325 8.47477 0.75 7.87477 0.75C7.26727 0.75 6.68977 0.8325 6.12727 0.975C6.11977 1.0275 6.12727 1.0725 6.11227 1.1325C5.79727 2.0775 5.56477 3.045 5.38477 4.02C7.04227 3.84 8.70727 3.84 10.3648 4.02Z" fill="#99A1B7"/>
                                        <path d="M4.02 5.38501C3.0375 5.56501 2.0775 5.79751 1.125 6.11251C1.0725 6.12751 1.0275 6.12751 0.975 6.13501C0.8325 6.69001 0.75 7.27501 0.75 7.87501C0.75 8.48251 0.8325 9.06001 0.975 9.62251C1.0275 9.63001 1.0725 9.62251 1.1325 9.63751C2.0775 9.95251 3.045 10.185 4.0275 10.365C3.84 8.70751 3.84 7.04251 4.02 5.38501Z" fill="#99A1B7"/>
                                        <path d="M14.7752 6.13501C14.7227 6.13501 14.6777 6.12751 14.6177 6.11251C13.6727 5.79751 12.6977 5.56501 11.7227 5.38501C11.9102 7.04251 11.9102 8.70751 11.7227 10.3575C12.6977 10.1775 13.6727 9.95251 14.6177 9.63001C14.6702 9.61501 14.7152 9.62251 14.7752 9.61501C14.9102 9.05251 15.0002 8.47501 15.0002 7.86751C15.0002 7.27501 14.9177 6.69751 14.7752 6.13501Z" fill="#99A1B7"/>
                                        <path d="M5.38477 11.73C5.56477 12.7125 5.78977 13.68 6.11227 14.625C6.12727 14.6775 6.11977 14.7225 6.12727 14.7825C6.68977 14.9175 7.26727 15 7.87477 15C8.47477 15 9.05977 14.9175 9.61477 14.775C9.62227 14.7225 9.62227 14.6775 9.63727 14.6175C9.95227 13.6725 10.1848 12.705 10.3648 11.7225C9.53977 11.8125 8.70727 11.88 7.87477 11.88C7.04227 11.88 6.20977 11.82 5.38477 11.73Z" fill="#99A1B7"/>
                                        <path d="M5.2127 5.21245C4.9877 6.98245 4.9877 8.76745 5.2127 10.545C6.9827 10.77 8.7677 10.77 10.5452 10.545C10.7702 8.77495 10.7702 6.98995 10.5452 5.21245C8.7677 4.98745 6.9827 4.98745 5.2127 5.21245Z" fill="#99A1B7"/>
                                    </svg>
                                    <span class="mt-2px">{{ get_phrase('Shipping Addresses') }}</span>
                                </span>                                               
                            </a>
                        </li>
                        <li class="sidebar-nav-item">
                            <a href="{{ route('customer.payments') }}" class="sidebar-nav-link @if($current_route == 'customer.payments' || $current_route == 'customer.payment.invoice') active @endif">
                                <span class="d-flex align-items-start gap-6px">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                        <path d="M16.0874 10.23V10.98C16.0874 11.1825 15.9299 11.3475 15.7199 11.355H14.6249C14.2274 11.355 13.8674 11.0625 13.8374 10.6725C13.8149 10.44 13.9049 10.2225 14.0549 10.0725C14.1899 9.92998 14.3774 9.85498 14.5799 9.85498H15.7124C15.9299 9.86248 16.0874 10.0275 16.0874 10.23Z" fill="#99A1B7"/>
                                        <path d="M13.4924 9.51748C13.1174 9.88498 12.9374 10.4325 13.0874 11.0025C13.2824 11.7 13.9649 12.1425 14.6849 12.1425H15.3374C15.7499 12.1425 16.0874 12.48 16.0874 12.8925V13.035C16.0874 14.5875 14.8199 15.855 13.2674 15.855H4.6574C3.1049 15.855 1.8374 14.5875 1.8374 13.035V7.98748C1.8374 7.06498 2.2799 6.24748 2.9624 5.73748C3.4349 5.37748 4.0199 5.16748 4.6574 5.16748H13.2674C14.8199 5.16748 16.0874 6.43498 16.0874 7.98748V8.31748C16.0874 8.72998 15.7499 9.06748 15.3374 9.06748H14.5724C14.1524 9.06748 13.7699 9.23248 13.4924 9.51748Z" fill="#99A1B7"/>
                                        <path d="M12.1498 3.615C12.3523 3.8175 12.1798 4.1325 11.8948 4.1325L6.1348 4.125C5.8048 4.125 5.6323 3.72 5.8723 3.4875L7.0873 2.265C8.1148 1.245 9.7798 1.245 10.8073 2.265L12.1198 3.5925C12.1273 3.6 12.1423 3.6075 12.1498 3.615Z" fill="#99A1B7"/>
                                    </svg>
                                    <span class="mt-2px">{{ get_phrase('Payments') }}</span>
                                </span>                                               
                            </a>
                        </li>
                        <li class="sidebar-nav-item">
                            <a href="{{ route('customer.messages') }}" class="sidebar-nav-link @if($current_route == 'customer.messages') active @endif">
                                <span class="d-flex align-items-start gap-6px">
                                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M12.75 15.375H5.25C3 15.375 1.5 14.25 1.5 11.625V6.375C1.5 3.75 3 2.625 5.25 2.625H12.75C15 2.625 16.5 3.75 16.5 6.375V11.625C16.5 14.25 15 15.375 12.75 15.375Z" stroke="#99A1B7" stroke-width="1.4" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                        <path d="M12.75 6.75L10.4025 8.625C9.63 9.24 8.3625 9.24 7.59 8.625L5.25 6.75" stroke="#99A1B7" stroke-width="1.4" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                    <span class="mt-2px">{{ get_phrase('Message') }}</span>
                                </span>                                               
                            </a>
                        </li>
                        <li class="sidebar-nav-item"><a href="{{ route('customer.account') }}" class="sidebar-nav-link @if($current_route == 'customer.account') active @endif">
                            <span class="d-flex align-items-start gap-6px">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                    <path d="M15.9377 13.8525L14.7002 14.145C14.4227 14.2125 14.2052 14.4225 14.1452 14.7L13.8827 15.8025C13.7402 16.4025 12.9752 16.59 12.5777 16.1175L10.3352 13.5375C10.1552 13.3275 10.2527 12.9975 10.5227 12.93C11.8502 12.6075 13.0427 11.865 13.9202 10.8075C14.0627 10.635 14.3177 10.6125 14.4752 10.77L16.1402 12.435C16.7102 13.005 16.5077 13.7175 15.9377 13.8525Z" fill="#99A1B7"/>
                                    <path d="M2.02488 13.8525L3.26238 14.145C3.53988 14.2125 3.75738 14.4225 3.81738 14.7L4.07988 15.8025C4.22238 16.4025 4.98738 16.59 5.38488 16.1175L7.62738 13.5375C7.80738 13.3275 7.70988 12.9975 7.43988 12.93C6.11238 12.6075 4.91988 11.865 4.04238 10.8075C3.89988 10.635 3.64488 10.6125 3.48738 10.77L1.82238 12.435C1.25238 13.005 1.45488 13.7175 2.02488 13.8525Z" fill="#99A1B7"/>
                                    <path d="M9 1.5C6.0975 1.5 3.75 3.8475 3.75 6.75C3.75 7.8375 4.0725 8.835 4.6275 9.6675C5.4375 10.8675 6.72 11.715 8.2125 11.9325C8.4675 11.9775 8.73 12 9 12C9.27 12 9.5325 11.9775 9.7875 11.9325C11.28 11.715 12.5625 10.8675 13.3725 9.6675C13.9275 8.835 14.25 7.8375 14.25 6.75C14.25 3.8475 11.9025 1.5 9 1.5ZM11.295 6.585L10.6725 7.2075C10.5675 7.3125 10.5075 7.515 10.545 7.665L10.725 8.4375C10.8675 9.045 10.545 9.285 10.005 8.9625L9.255 8.52C9.12 8.4375 8.895 8.4375 8.76 8.52L8.01 8.9625C7.47 9.2775 7.1475 9.045 7.29 8.4375L7.47 7.665C7.5 7.5225 7.4475 7.3125 7.3425 7.2075L6.705 6.585C6.3375 6.2175 6.4575 5.85 6.9675 5.7675L7.77 5.6325C7.905 5.61 8.0625 5.49 8.1225 5.37L8.565 4.485C8.805 4.005 9.195 4.005 9.435 4.485L9.8775 5.37C9.9375 5.49 10.095 5.61 10.2375 5.6325L11.04 5.7675C11.5425 5.85 11.6625 6.2175 11.295 6.585Z" fill="#99A1B7"/>
                                </svg>
                                <span class="mt-2px capitalize">{{ get_phrase('Account') }}</span>
                            </span>                                               
                        </a></li>
                    </ul>
                </nav>
            </div>
           
            @if(auth()->user()->is_vendor == 1)
                <div class="d-flex align-items-center gap-12px flex-wrap mb-18px">
                    <a href="{{ route('vendor.dashboard') }}" class="btn up-btn-dark w-100 mx-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M2 7L3 3H17L18 7H2Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M2 7H18V17H2V7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M6 17V11H14V17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        <span>{{ get_phrase('Store Dashboard') }}</span>
                    </a>
                </div>
            @else
                <div class="d-flex align-items-center gap-12px flex-wrap mb-18px">
                    <a href="{{ route('customer.become.vendor') }}" class="btn up-btn-dark w-100 mx-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M2 7L3 3H17L18 7H2Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M2 7H18V17H2V7Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M6 17V11H14V17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        <span>{{ get_phrase('Become a vendor') }}</span>
                    </a>
                </div>
            @endif

            <div class="d-flex align-items-center gap-12px flex-wrap">
                <a href="{{ route('logout') }}" class="btn up-btn-dark w-100 mx-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                        <path d="M12.6991 18.5586L12.5908 18.5586C8.89079 18.5586 7.10745 17.1002 6.79912 13.8336C6.76579 13.4919 7.01579 13.1836 7.36579 13.1502C7.69912 13.1169 8.01579 13.3752 8.04912 13.7169C8.29079 16.3336 9.52412 17.3086 12.5991 17.3086L12.7075 17.3086C16.0991 17.3086 17.2991 16.1086 17.2991 12.7169L17.2991 7.28356C17.2991 3.89189 16.0991 2.69189 12.7075 2.69189L12.5991 2.69189C9.50745 2.69189 8.27412 3.68356 8.04912 6.35023C8.00745 6.69189 7.71579 6.95023 7.36579 6.91689C7.01579 6.89189 6.76578 6.58356 6.79078 6.24189C7.07412 2.92523 8.86578 1.44189 12.5908 1.44189L12.6991 1.44189C16.7908 1.44189 18.5408 3.19189 18.5408 7.28356L18.5408 12.7169C18.5408 16.8086 16.7908 18.5586 12.6991 18.5586Z" fill="white"/>
                        <path d="M12.499 10.625L3.01563 10.625C2.67396 10.625 2.39063 10.3417 2.39063 10C2.39063 9.65833 2.67396 9.375 3.01562 9.375L12.499 9.375C12.8406 9.375 13.124 9.65833 13.124 10C13.124 10.3417 12.8406 10.625 12.499 10.625Z" fill="white"/>
                        <path d="M4.87552 13.4167C4.71719 13.4167 4.55886 13.3584 4.43386 13.2334L1.64219 10.4417C1.40052 10.2 1.40052 9.80003 1.64219 9.55837L4.43385 6.7667C4.67552 6.52503 5.07552 6.52503 5.31719 6.7667C5.55885 7.00837 5.55885 7.40837 5.31719 7.65003L2.96719 10L5.31719 12.35C5.55885 12.5917 5.55885 12.9917 5.31719 13.2334C5.20052 13.3584 5.03385 13.4167 4.87552 13.4167Z" fill="white"/>
                    </svg>
                    <span>{{ get_phrase('Sign Out') }}</span>
                </a>
            </div>
        </div>
    </div>
</div>