@extends('layouts.customer')
@push('title', get_phrase('Become a vendor'))
@push('meta')
@endpush
@push('css')
@endpush

@section('content')
    <!-- Start Main Area -->
    <section>
        <div class="container">
            <div class="row mt-3 mb-100px">
                <div class="col-xl-3 col-lg-4">
                    @include('frontend.customer_navigation')
                </div>
                <div class="col-xl-9 col-lg-8">
                    <!-- Top Area -->
                    <div class="d-flex align-items-start justify-content-between gap-2 mb-20px">
                        <div
                            class="d-flex justify-content-between align-items-start align-items-lg-center gap-12px flex-column flex-lg-row w-100">
                            <h1 class="in-title-16px">{{ get_phrase('Become a vendor') }}</h1>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb up-breadcrumb">
                                    <li class="breadcrumb-item up-breadcrumb-item"><a
                                            href="{{ route('home') }}">{{ get_phrase('Home') }}</a></li>
                                    <li class="breadcrumb-item up-breadcrumb-item active" aria-current="page">
                                        {{ get_phrase('Become a vendor') }}</li>
                                </ol>
                            </nav>
                        </div>
                        <button class="btn up-icon-btn-secondary d-lg-none" type="button" data-bs-toggle="offcanvas"
                            data-bs-target="#up-sidebar-offcanvas" aria-controls="user-sidebar-offcanvas">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M21 5.25H3C2.59 5.25 2.25 4.91 2.25 4.5C2.25 4.09 2.59 3.75 3 3.75H21C21.41 3.75 21.75 4.09 21.75 4.5C21.75 4.91 21.41 5.25 21 5.25Z"
                                    fill="#242D47"></path>
                                <path
                                    d="M21 10.25H3C2.59 10.25 2.25 9.91 2.25 9.5C2.25 9.09 2.59 8.75 3 8.75H21C21.41 8.75 21.75 9.09 21.75 9.5C21.75 9.91 21.41 10.25 21 10.25Z"
                                    fill="#242D47"></path>
                                <path
                                    d="M21 15.25H3C2.59 15.25 2.25 14.91 2.25 14.5C2.25 14.09 2.59 13.75 3 13.75H21C21.41 13.75 21.75 14.09 21.75 14.5C21.75 14.91 21.41 15.25 21 15.25Z"
                                    fill="#242D47"></path>
                                <path
                                    d="M21 20.25H3C2.59 20.25 2.25 19.91 2.25 19.5C2.25 19.09 2.59 18.75 3 18.75H21C21.41 18.75 21.75 19.09 21.75 19.5C21.75 19.91 21.41 20.25 21 20.25Z"
                                    fill="#242D47"></path>
                            </svg>
                        </button>
                    </div>
                    <!-- Content Area -->
                    <div class="up-content-box">
                        <form action="{{ route('customer.become.vendor.store') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="mb-30px">
                                <div class="row gx-12px gy-3 mb-3">
                                    <div class="col-md-12">
                                        <div>
                                            <label for="user-name2"
                                                class="form-label up-form-label">{{ get_phrase('Name') }}</label>
                                            <input name="name" value="{{ auth()->user()->name }}" type="text"
                                                class="form-control up-form-control" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div>
                                            <label for="user-email3"
                                                class="form-label up-form-label">{{ get_phrase('Email') }}</label>
                                            <input name="email" value="{{ auth()->user()->email }}" type="email"
                                                class="form-control up-form-control"
                                                placeholder="{{ get_phrase('Email address') }}" readonly>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div>
                                            <label for="user-name2"
                                                class="form-label up-form-label">{{ get_phrase('Phone') }}</label>
                                            <input name="phone" value="{{ auth()->user()->phone }}" type="text"
                                                class="form-control up-form-control" placeholder="Phone">
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div>
                                            <label for="store_name" class="form-label up-form-label">{{ get_phrase('Store name') }}</label>
                                            <input name="store_name" type="text" class="form-control up-form-control" placeholder="{{ get_phrase('Store name') }}">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div>
                                            <label for="store_description" class="form-label up-form-label">{{ get_phrase('Store description') }}</label>
                                            <textarea name="store_description" class="form-control up-form-label" id="store_description" rows="10" placeholder="{{ get_phrase('Store description') }}"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-center gap-12px flex-wrap">
                                <button type="submit" class="btn up-btn-dark">{{ get_phrase('Apply for vendor') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('js')

@endpush
