<!-- Banner  Area Start -->
    <section class="banner-area">
        <div class="container">
            <div class="row gx-4 gy-5">
                <div class="col-lg-6">
                    <div class="banner-left position-relative wow animate__fadeInUp" data-wow-delay=".1s">
                        <figure class="mb-0">
                            <div class="figure-top">
                                <span class="tr-gears">{{get_phrase('Best Platform for Travel Gears')}}</span>
                            </div>
                            <div class="figure-middle position-relative">
                                <h1 class="bn-title">{{get_phrase('Gear Up for Every Journey!')}}</h1>
                                <p class="bn-subtitle">{{get_phrase('Explore durable, smart, and eco-conscious travel essentials built for every adventure.')}}</p>
                                <div class="banner-btn">
                                    <a href="{{route('all_products')}}" class="tr-gradient1-btn">{{get_phrase('Shop Now!')}}</a>
                                    <a href="{{route('all_products')}}" class="products_btn">
                                        <span>{{get_phrase('View Products')}}</span> 
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 14 15" fill="none">
                                            <path d="M14 1.87305C14 1.32076 13.5523 0.873047 13 0.873048L4 0.873048C3.44771 0.873048 3 1.32076 3 1.87305C3 2.42533 3.44771 2.87305 4 2.87305L12 2.87305L12 10.873C12 11.4253 12.4477 11.873 13 11.873C13.5523 11.873 14 11.4253 14 10.873L14 1.87305ZM1 13.873L1.70711 14.5802L13.7071 2.58015L13 1.87305L12.2929 1.16594L0.292893 13.1659L1 13.873Z" fill="white"/>
                                        </svg>
                                    </a>
                                </div>
                                <div class="bn-product-info-wrap">
                                    <div class="bn-product-info">
                                        <div class="dark-iconbox">
                                            <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <mask id="mask0_33_3533" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="32" height="32">
                                                <path d="M0.125 0.124464H31.646V31.6455H0.125V0.124464Z" fill="white"/>
                                                </mask>
                                                <g mask="url(#mask0_33_3533)">
                                                <path d="M15.8854 8.68188C17.9877 8.68188 19.7024 6.96719 19.7024 4.86488C19.7024 2.76258 17.9877 1.04788 15.8854 1.04788C13.7831 1.04788 12.0684 2.76258 12.0684 4.86488C12.0684 6.96719 13.7831 8.68188 15.8854 8.68188Z" stroke="white" stroke-width="1.07835" stroke-miterlimit="22.926" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M8.86621 21.0564V12.5484C8.86621 10.8588 10.2379 9.48079 11.9198 9.48079H19.8493C21.5312 9.48079 22.9029 10.8592 22.9029 12.5484V20.9948" stroke="white" stroke-width="1.07835" stroke-miterlimit="22.926" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M10.9605 27.767L9.23233 27.8007L6.78219 30.6406L5.41114 27.1495L1.95312 25.6968L4.8498 23.3141L5.16279 19.5764L8.32401 21.595" stroke="white" stroke-width="1.07835" stroke-miterlimit="22.926" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M20.5645 27.682L22.5389 27.8007L24.989 30.6406L26.3601 27.1495L29.8181 25.6968L26.9214 23.3141L26.6085 19.5764L23.5193 21.549" stroke="white" stroke-width="1.07835" stroke-miterlimit="22.926" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M15.8859 15.854L18.5956 20.3434L23.7025 21.533L20.2702 25.4973L20.7169 30.7219L15.8859 28.6826L11.055 30.7219L11.5017 25.4973L8.06934 21.533L13.1764 20.3434L15.8859 15.854Z" stroke="white" stroke-width="1.07835" stroke-miterlimit="22.926" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M15.8857 8.86537V12.9875" stroke="white" stroke-width="1.07835" stroke-miterlimit="22.926" stroke-linecap="round" stroke-linejoin="round"/>
                                                </g>
                                            </svg>
                                        </div>
                                        <p class="bn-product-info-text">{{get_phrase('Experienced & Certified Products')}}</p>
                                    </div>
                                    <div class="bn-product-info">
                                        <div class="dark-iconbox">
                                            <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <mask id="mask0_33_3555" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="32" height="32">
                                                <path d="M0.124023 0.124464H31.6451V31.6455H0.124023V0.124464Z" fill="white"/>
                                                </mask>
                                                <g mask="url(#mask0_33_3555)">
                                                <path d="M20.3087 21.5501C19.8739 22.1711 19.6406 22.9108 19.6406 23.6689V27.0281H27.0284L30.2244 19.5705C30.5529 18.8042 30.7222 17.9791 30.7222 17.1454V10.4056C30.7222 9.38559 29.8954 8.55871 28.8753 8.55871C27.8553 8.55871 27.0284 9.38559 27.0284 10.4056V15.5947C27.0284 16.6223 26.6951 17.6221 26.0786 18.4442" stroke="white" stroke-width="1.07835" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M27.0284 27.0281H19.6406V30.7219H27.0284V27.0281Z" stroke="white" stroke-width="1.07835" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M24.431 22.1135L25.8445 20.0948C26.4296 19.2593 26.2265 18.1076 25.3909 17.5225C24.5554 16.9375 23.4037 17.1406 22.8186 17.9761L20.3086 21.5608" stroke="white" stroke-width="1.07835" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M11.4614 21.5501C11.8962 22.1711 12.1295 22.9108 12.1295 23.6689V27.0281H4.74172L1.54566 19.5705C1.21722 18.8042 1.04785 17.9791 1.04785 17.1454V10.4056C1.04785 9.38559 1.87472 8.55871 2.89479 8.55871C3.91479 8.55871 4.74172 9.38559 4.74172 10.4056V15.5947C4.74172 16.6223 5.07503 17.6221 5.69154 18.4442" stroke="white" stroke-width="1.07835" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M4.74219 27.0281H12.1299V30.7219H4.74219V27.0281Z" stroke="white" stroke-width="1.07835" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M7.33849 22.1135L5.92497 20.0948C5.33992 19.2593 5.54302 18.1076 6.37857 17.5225C7.21413 16.9375 8.36582 17.1406 8.95086 17.9761L11.4609 21.5608" stroke="white" stroke-width="1.07835" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M16.0524 2.4982L15.8857 2.66492L15.7189 2.4982C13.7853 0.564583 10.6504 0.564645 8.71684 2.4982C6.78322 4.43176 6.78316 7.56669 8.71684 9.50031L15.8857 16.6692L23.0545 9.50031C24.9881 7.56675 24.9881 4.43176 23.0545 2.4982C21.1209 0.564583 17.9859 0.564645 16.0524 2.4982Z" stroke="white" stroke-width="1.07835" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                                </g>
                                            </svg>
                                        </div>
                                        <p class="bn-product-info-text">{{get_phrase('100k+ of Products Sell!')}}</p>
                                    </div>
                                </div>
                            </div>
                        </figure>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="banner-slider-area ms-xl-5 ms-lg-4 wow animate__fadeInUp" data-wow-delay=".1s">
                        <!-- Swiper -->
                        <div class="swiper bn-slider">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide">
                                    <div class="bn-slider-banner">
                                        <img class="banner" src="{{ asset('assets/frontend/travel-dark/images/banner.webp') }}" alt="">
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="bn-slider-banner">
                                        <img class="banner" src="{{ asset('assets/frontend/travel-dark/images/banner.webp') }}" alt="">
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="bn-slider-banner">
                                        <img class="banner" src="{{ asset('assets/frontend/travel-dark/images/banner.webp') }}" alt="">
                                    </div>
                                </div>
                            </div>
                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Banner  Area End -->

<!-- Brand Slider Area End -->
<section class="brand-slider-section">
    <div class="brand-slider-area1">
        <!-- Swiper -->
        <div class="swiper brand-slider brand-slider1">
            <div class="swiper-wrapper">
                 @php 
                    $brands = App\Models\Brand::get();
                  @endphp
                    @foreach($brands as $brand)  
                        <div class="swiper-slide">
                            <div class="brand-slide">
                                <img class="brand" src="{{ get_image($brand->logo) }}" alt="">
                            </div>
                        </div>
                    @endforeach
            </div>
        </div>
    </div>
    <div class="brand-slider-area2">
        <!-- Swiper -->
        <div class="swiper brand-slider brand-slider2">
            <div class="swiper-wrapper">
                 @foreach($brands as $brand) 
                        <div class="swiper-slide">
                            <div class="brand-slide">
                                <img class="brand" src="{{ get_image($brand->logo) }}" alt="">
                            </div>
                        </div>
                    @endforeach

            </div>
        </div>
    </div>
</section>
<!-- Brand Slider Area End -->

<!-- Category Area Start -->
<section class="category-area">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <div class="tr-section wow animate__fadeInUp" data-wow-delay=".1s">
                    <div class="arrow-line"></div>
                    <span class="d-block">{{get_phrase('Shop by Category')}}</span>
                    <h2 class="mb-2">{{get_phrase('Essential Gear for Every Kind of Traveler.')}}</h2>
                    <p>{{get_phrase('Explore durable, smart, and eco-conscious travel essentials built for every adventure.')}}</p>
                </div>
            </div>
        </div>
        <div class="row  wow animate__fadeInUp" data-wow-delay=".1s">
            <div class="col-lg-12">
                 <div class="category-gallary overflow-hidden">
                            @php
                                $categories = App\Models\Category::where('parent_id', '=', 0)->orderBy('sort', 'asc')->orderBy('title', 'asc')->take(6)->get();
                            @endphp
                            @if($categories->count())
                                <div class="itemBox d-flex">
                                    {{-- Left Big Item --}}
                                    @php $first = $categories->first(); @endphp
                                    <a href="{{ route('products', get_category_params($first)) }}" class="itemLeft items">
                                        <div class="cate-save-icon">
                                            <span><img src="{{ asset('assets/frontend/travel-dark/images/line.svg') }}" alt=""></span>
                                        </div>
                                        <img class="cate-image" src="{{ get_image($first->thumbnail) }}" alt="category image">
                                        <div class="item-content">
                                            <span class="cat-icon">
                                                <img src="{{ get_image($first->icon) }}" alt="">
                                            </span>
                                            <h4>{{ $first->title }}</h4>
                                        </div>
                                    </a>

                                    {{-- Right Side --}}
                                    <div class="itemRight">
                                        {{-- Top 2 items --}}
                                        <div class="tr-item-top d-flex">
                                            @foreach($categories->skip(1)->take(2) as $cat)
                                                <a href="{{ route('products', get_category_params($cat)) }}" class="item{{ $loop->iteration + 1 }} items">
                                                    <div class="cate-save-icon">
                                                        <span><img src="{{ asset('assets/frontend/travel-dark/images/line.svg') }}" alt=""></span>
                                                    </div>
                                                    <img class="cate-image" src="{{ get_image($cat->thumbnail) }}" alt="category image">
                                                    <div class="item-content">
                                                        <span class="cat-icon">
                                                            <img src="{{ get_image($cat->icon) }}" alt="">
                                                        </span>
                                                        <h4>{{ $cat->title }}</h4>
                                                    </div>
                                                </a>
                                            @endforeach
                                        </div>

                                        {{-- Bottom 3 items --}}
                                        <div class="tr-item-bottom d-flex">
                                            @foreach($categories->skip(3)->take(3) as $cat)
                                                <a href="{{ route('products', get_category_params($cat)) }}" class="item{{ $loop->iteration + 3 }} items">
                                                    <div class="cate-save-icon">
                                                        <span><img src="{{ asset('assets/frontend/travel-dark/images/line.svg') }}" alt=""></span>
                                                    </div>
                                                    <img class="cate-image" src="{{ get_image($cat->thumbnail) }}" alt="category image">
                                                    <div class="item-content">
                                                        <span class="cat-icon">
                                                            <img src="{{ get_image($cat->icon) }}" alt="">
                                                        </span>
                                                        <h4>{{ $cat->title }}</h4>
                                                    </div>
                                                </a>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                  <div class="text-center mt-2">
                     <a href="{{route('all_products')}}" class="tr-white-btn-large mt-5">{{get_phrase('Shop Now')}}</a>
                  </div>
            </div>
        </div>
    </div> 
</section>
<!-- Category Area End -->
<!-- Tranding Products Area Start -->
 <section class="tr-tranding-products">
    <div class="container">
        <div class="row wow animate__fadeInUp" data-wow-delay=".1s">
            <div class="col-12">
                <div class="trending-section-title-area tr-section">
                    <div class="arrow-line"></div>
                    <span class="d-block mb-40px">{{get_phrase('Trending Products')}}</span>
                    <div class="trending-section-title-main">
                        <div class="trending-section-title-left">
                            <h2 class="mb-2">{{get_phrase('Top Picks Travelers Always Love!')}}</h2>
                        </div>
                        <div class="trending-section-title-right">
                            <p>{{get_phrase('Join thousands of happy travelers who swear by these must-haves. From smart luggage to compact organizers.')}}</p>
                            <a href="{{route('all_products')}}" class="tr-white-btn-large px-3 mt-5">{{get_phrase('View All Products')}}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mt-5 pt-4 wow animate__fadeInUp" data-wow-delay=".2s">
            <!-- Tranding card -->
            @php 
               $products = App\Models\Product::where('status', 1)->latest()->take(6)->get(); 
            @endphp
            @foreach($products as $product)
            <div class="col-lg-4 col-md-6 col-sm-12  mb-5">
                <div class="tr-tranding-card">
                    <div class="tr-tranding-image">
                        <div class="tr-title d-flex justify-content-between">
                            <h4>{{ $product->title}}</h4>
                            <span  class="product-card-wishlist {{ wishlist_class($product->id) }}" 
                                onclick="toggleWishlist({{ $product->id }}, this)" data-bs-toggle="tooltip" data-bs-title="Wishlist">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M11.9998 4.49509C13.0949 3.48589 14.5211 2.91895 16.0098 2.91895C17.6173 2.91895 19.1519 3.58001 20.2755 4.74512C21.3911 5.90102 22.0122 7.4592 22.0122 9.07738C22.0122 10.6956 21.391 12.2539 20.2755 13.4096C19.5338 14.1786 18.7932 14.9649 18.0487 15.7554C16.5366 17.361 15.0084 18.9837 13.4208 20.5126L13.4171 20.5161C12.5984 21.293 11.3019 21.2647 10.5181 20.4524L3.72374 13.4096C1.40898 11.0102 1.40898 7.14465 3.72374 4.74523C5.98889 2.39723 9.63646 2.31385 11.9998 4.49509Z" fill="#4A4A4A"/>
                            </svg>
                            </span>
                        </div>
                        @php
                            $thumbnails = json_decode($product->thumbnail, true);
                            $firstImage = $thumbnails[0] ?? null;
                        @endphp
                        <img src="{{ get_image($firstImage) }}" alt="image">
                    </div>
                    <div class="tr-tranding-bottom">
                        <div class="tr-price">
                            
                             @if ($product->is_discounted)
                                @php
                                    $discount = $product->discount;
                                @endphp
                                @if ($discount->discount_type == 'percentage')
                                   <p class="newPrice">{{ currency(($product->price / 100) * $discount->discount_value) }}</p>
                                   <p class="delPrice">{{ currency($product->price) }}</p>
                                @else
                                    <p class="newPrice">{{ currency($product->price) }}</p>
                                @endif
                                @else
                                    <p class="newPrice">{{ currency($product->price) }}</p>
                                @endif

                        </div>
                        <div class="tr-review">
                            <ul class="d-flex">
                                  @php
                                    $rating = $product->average_rating;
                                    $fullStars = floor($rating); // full stars count
                                    $halfStar = ($rating - $fullStars) >= 0.5 ? 1 : 0; // half star check
                                    $emptyStars = 5 - ($fullStars + $halfStar);
                                @endphp
                                @for($i = 0; $i < $fullStars; $i++)
                                   <li><img src="{{ asset('assets/frontend/travel-dark/images/rating1.svg') }}" alt=""></li>
                                @endfor
                                 @for($i = 0; $i < $emptyStars; $i++)
                                   <li><img src="{{ asset('assets/frontend/travel-dark/images/rating2.svg') }}" alt=""></li>
                                @endfor
                            </ul>
                            <p>{{ number_format($product->average_rating, 1) }}</p>
                        </div>
                    </div>
                      <a href="{{ route('product', $product->slug) }}" class="tr-white-btn-large w-100 text-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M26.6972 30.322C27.9107 30.322 28.8944 29.3415 28.8944 28.132C28.8944 26.9225 27.9107 25.9419 26.6972 25.9419C25.4838 25.9419 24.5 26.9225 24.5 28.132C24.5 29.3415 25.4838 30.322 26.6972 30.322Z" fill="black" stroke="black" stroke-width="1.7758" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M12.0488 30.322C13.2622 30.322 14.246 29.3415 14.246 28.132C14.246 26.9225 13.2622 25.9419 12.0488 25.9419C10.8353 25.9419 9.85156 26.9225 9.85156 28.132C9.85156 29.3415 10.8353 30.322 12.0488 30.322Z" fill="black" stroke="black" stroke-width="1.7758" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M5.4579 4.04117H30.3596L27.43 20.1016H8.38752L5.4579 4.04117ZM5.4579 4.04117C5.21376 3.06781 3.99309 1.12109 1.06348 1.12109" stroke="black" stroke-width="1.7758" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M27.43 20.1011H8.38753H5.79595C3.18228 20.1011 1.7959 21.2417 1.7959 23.0212C1.7959 24.8007 3.18228 25.9412 5.79595 25.9412H26.6976" stroke="black" stroke-width="1.7758" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>{{get_phrase('Shop Now')}}</a>
                </div>
            </div>
            @endforeach
            <!-- Tranding card -->
        </div>
    </div>
 </section>
<!-- Tranding Products Area End -->
<!-- Kit  Area Start -->
<section class="tr-kit-area">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-5">
                <div class="kit-image wow animate__fadeInLeft" data-wow-delay=".1s">
                    <img src="{{ asset('assets/frontend/travel-dark/images/kit.png') }}" alt="image">
                </div>
            </div>
            <div class="col-lg-7">
                  <div class="tr-section wow animate__fadeInRight" data-wow-delay=".1s">
                    <div class="arrow-line"></div>
                    <span class="d-block"> {{get_phrase('All-in-One Travel Kits')}}</span>
                    <h2 class="mb-2">{{get_phrase('Curated Bundles for Every Kind of Journey!')}}</h2>
                    <ul class="tr-kit-motion">
                        <li>
                            <span><img src="{{ asset('assets/frontend/travel-dark/images/key1.svg') }}" alt=""></span>
                            <div class="tr-kit-text">
                                <h5>{{get_phrase('Save up to 30% vs. buying individually')}}</h5>
                                <p>{{get_phrase('Save up to 30% compared to buying items individually')}}</p>
                            </div>
                        </li>
                        <li>
                            <span><img src="{{ asset('assets/frontend/travel-dark/images/key2.svg') }}" alt=""></span>
                            <div class="tr-kit-text">
                                <h5>{{get_phrase('Curated by real travelers')}}</h5>
                                <p>{{get_phrase('Curated by real travelers for real-world needs')}}</p>
                            </div>
                        </li>
                        <li>
                            <span><img src="{{ asset('assets/frontend/travel-dark/images/key3.svg') }}" alt=""></span>
                            <div class="tr-kit-text">
                                <h5>{{get_phrase('Perfect gift for travel lovers')}}</h5>
                                <p>{{get_phrase('Perfect gift for globetrotters and weekend explorers alike')}}</p>
                            </div>
                        </li>
                    </ul>
                     <a href="{{route('all_products')}}" class="tr-white-btn-large mt-5">{{get_phrase('Shop All Bundles')}}</a>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Kit Area End -->
 <!-- Trust us Area Start -->
  <section class="tr-trust-area">
     <div class="trust-image wow animate__fadeInRight" data-wow-delay=".1s">
          <img src="{{ asset('assets/frontend/travel-dark/images/image 8.png') }}" alt="">
      </div>
     
       <div class="container">
          <div class="row">
              <div class="col-lg-8">
                    <div class="tr-section trust-title-area wow animate__fadeInLeft position-relative" data-wow-delay=".1s">
                         <span class="vector position-absolute "><img src="{{ asset('assets/frontend/travel-dark/images/vector5.png') }}" alt="vector"></span>
                        <div class="arrow-line"></div>
                        <span class="d-block">{{get_phrase('Why Choose uS?')}}</span>
                        <h2 class="mb-2">{{get_phrase('Why Travelers Trust Us?')}}</h2>
                        <p class="description">{{get_phrase('Our gear is built to last, no matter where your journey takes you. Trusted by seasoned travelers and adventure seekers worldwide, every product is designed for durability, comfort, & performance')}}</p>
                       
                       <div class="trusted d-flex gap-2"> 
                         <ul class="tr-kit-motion ">
                            <li>
                                <span><img src="{{ asset('assets/frontend/travel-dark/images/key1.svg') }}" alt=""></span>
                                <div class="tr-kit-text">
                                    <h5>{{get_phrase('Durable Quality')}}</h5>
                                    <p>{{get_phrase('Built to withstand the rigors of global travel—tested for performance, comfort, & resilience.')}}</p>
                                </div>
                            </li>
                            <li>
                                <span><img src="{{ asset('assets/frontend/travel-dark/images/key4.svg') }}" alt=""></span>
                                <div class="tr-kit-text">
                                     <h5>{{get_phrase('Free Shipping')}}</h5>
                                    <p>{{get_phrase('Enjoy fast, free shipping on all domestic orders. No minimums, no hidden fees—just great gear delivered to your door.')}}</p>
                                </div>
                            </li>
                        </ul>
                        <ul class="tr-kit-motion ">
                            <li>
                                <span><img src="{{ asset('assets/frontend/travel-dark/images/key5.svg') }}" alt=""></span>
                                <div class="tr-kit-text">
                                    <h5>{{get_phrase('Innovative Design')}}</h5>
                                    <p>{{get_phrase('From anti-theft backpacks to space-saving cubes, every product is designed to solve real travel problems.')}}</p>
                                </div>
                            </li>
                            <li>
                                <span><img src="{{ asset('assets/frontend/travel-dark/images/key6.svg') }}" alt=""></span>
                                <div class="tr-kit-text">
                                    <h5>{{get_phrase('Eco-Friendly Options')}}</h5>
                                    <p>{{get_phrase('Travel lighter with gear made from recycled and sustainable materials. Good for the planet, great for your journey.')}}</p>
                                </div>
                            </li>
                           </ul>
                       </div>
                        <a href="{{route('all_products')}}" class="tr-white-btn-large px-3 mt-5">{{get_phrase('Explore Products')}}</a>
                    </div>
              </div>
              <div class="col-lg-4"></div>
          </div>
       </div> 
  </section>
 <!-- Trust us Area End  -->
 <!-- Testimonials Section  Start  -->
  <section class="testimonials-area wow animate__fadeInUp" data-wow-delay=".1s">
    <div class="tr-testimonials-image ">
        <img src="{{ asset('assets/frontend/travel-dark/images/testimonials_bg.png ') }}" alt="">
    </div>
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <div class="tr-section wow animate__fadeInUp" data-wow-delay=".1s">
                    <div class="arrow-line"></div>
                    <span class="d-block">{{get_phrase('Testimonials')}}</span>
                    <h2 class="mb-2">{{get_phrase('Loved by Thousands of Travelers!')}}</h2>
                    <p>{{get_phrase('Real stories. Real adventures. Real satisfaction.')}}</p>
                </div>
            </div>
            <!-- Testimonials  Slider  -->
             <div class="col-lg-2 col-md-2 col-sm-12"></div>
             <div class="col-lg-8 col-md-8 col-sm-12">
                <div class="testimonials-slider swiper wow animate__fadeInUp" data-wow-delay=".1s">
                     <div class="swiper-wrapper">
                            <!-- Slider -->
                            @foreach($reviews as $review)
                            <div class="swiper-slide tr-slider-content">
                                    <span><img src="{{ asset('assets/frontend/travel-dark/images/testi_frame.png ') }}" alt=""></span>
                                    <img class="tr-sImage"  src="{{ get_image($review->user->photo) }}" alt="">
                                    <p>{{$review->comment}}</p>
                                    <div class="userInfo">
                                        <h4> {{ $review->user->name }}</h4>
                                        <span>{{ $review->created_at->format('F j, Y') }}</span> 
                                    </div>
                            </div>
                          @endforeach
                            <!-- Slider -->
                     </div>
                </div>
             </div>
             <div class="col-lg-2 col-md-2 col-sm-12"></div>
        </div>
    </div>
  </section>
 <!-- Testimonials Section  End  -->
 <!-- Adventure  Section  Start  -->
  <section class="adventure-area">
     <div class="container">
        <div class="row g-3 wow animate__fadeInUp" data-wow-delay=".1s">
            <div class="col-lg-4 col-md-6 ">
                 <div class="tr-adventure-box">
                     <div class="tr-section ">
                        <div class="arrow-line"></div>
                        <span class="d-block">{{get_phrase('Adventure Inspiration')}}</span>
                        <h2>{{get_phrase('Fuel your next great escape.')}}</h2>
                    </div>
                    <div class="position-relative">
                      <div class="tr-adventure">
                          <img  src="{{ asset('assets/frontend/travel-dark/images/ad1.png ') }}" alt="">
                       </div>
                        <div class="tr-ad-motion">
                            <img src="{{ asset('assets/frontend/travel-dark/images/instagram.png ') }}" alt="...">
                            <p>{{get_phrase('Instagram')}}</p>
                         </div>
                    </div>
                 </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="tr-adventure-box">
                    <div class="position-relative">
                      <div class="tr-adventure">
                          <img  src="{{ asset('assets/frontend/travel-dark/images/ad2.png ') }}" alt="">
                       </div>
                        <div class="tr-ad-motion">
                            <img src="{{ asset('assets/frontend/travel-dark/images/instagram.png ') }}" alt="...">
                            <p>{{get_phrase('Instagram')}}</p>
                         </div>
                    </div>
                 </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="tr-adventure-box">
                    <div class="position-relative">
                      <div class="tr-adventure">
                          <img  src="{{ asset('assets/frontend/travel-dark/images/ad3.png ') }}" alt="">
                       </div>
                        <div class="tr-ad-motion">
                            <img src="{{ asset('assets/frontend/travel-dark/images/instagram.png ') }}" alt="...">
                            <p>{{get_phrase('Instagram')}}</p>
                         </div>
                    </div>
                      <div class="tr-ad-content">
                         <p>{{get_phrase('From mountain peaks to bustling city streets, our gear has been part of thousands of unforgettable adventures. See how travelers around the world pack, explore, and thrive with our essentials by their side.')}}</p>
                         <a href="{{route('all_products')}}" class="tr-white-btn-large">{{get_phrase('Share Your Journey')}}</a>
                    </div>
                 </div>
            </div>
        </div>
     </div>
  </section>
 <!-- Adventure  Section  End   -->
  <!-- Promotion Section Start -->
   <section class="promotion-area">
      <div class="container">
         <div class="row g-5 align-items-center">
            <div class="col-lg-7">
                <div class="tr-promotion-left position-relative  wow animate__fadeInLeft" data-wow-delay=".1s">
                    <img src="{{ asset('assets/frontend/travel-dark/images/promotion.png ') }}" alt="">
                    <div class="tr-promo">
                        <span class="right-promo vector" ><img  src="{{ asset('assets/frontend/travel-dark/images/vector4.png ') }}" alt="vector"></span>
                    </div>
                </div> 
            </div>
            <div class="col-lg-5">
                  <div class="tr-section wow animate__fadeInRight" data-wow-delay=".1s">
                    <div class="arrow-line"></div>
                    <span class="d-block">{{get_phrase('Our Deals & Promotions')}}</span>
                    <h2>{{get_phrase('Big adventures start with even bigger savings.')}}</h2>
                    <p>{{get_phrase("Discover limited-time offers on your favorite travel essentials—bundles, backpacks, accessories, and more. Whether you're planning a weekend escape or a world tour, now’s the perfect time to gear up for less.")}}</p>
                     <a href="{{route('all_products')}}" class="tr-white-btn-large px-28px">{{get_phrase('Shop All Deals')}}</a>
                </div>
            </div>
         </div>
      </div>
   </section>
  <!-- Promotion Section End -->
<!-- Blog Section Start -->
<section class="blog-area">
    <div class="container">
          <div class="row mb-5">
             <div class="col-12 text-center wow animate__fadeInUp" data-wow-delay=".1s">
                    <div class="tr-section">
                        <div class="arrow-line"></div>
                        <span class="d-block">{{get_phrase('Blogs Posts')}}</span>
                        <h2 class="mb-2">{{get_phrase('Travel Smarter with Our Guides')}}</h2>
                        <p>{{get_phrase('Expert tips, gear reviews, and destination inspiration to help you travel lighter, smarter, and better.')}}</p>
                    </div>
                </div>
          </div>
        <div class="row g-3 wow animate__fadeInUp" data-wow-delay=".1s">
            @foreach($blogs->take(3) as $key=>$blog)
         
            @if($loop ->first)
            <div class="col-lg-12">
                <a href="{{ route('blog_details', ['slug' => $blog->slug]) }}" class="tr-blog">
                    <div class="tr-big-image">
                        <img src="{{ get_image($blog->thumbnail) }}" alt="">
                    </div>
                    <div class="tr-blog-content">
                        <div class="blog-head">
                            <div class="d-flex align-items-center">
                                <img src="{{ asset('assets/frontend/travel-dark/images/bg-cal.svg') }}" alt="">
                                <p>{{ $blog->created_at->format('d M, Y') }}</p>
                            </div>
                             
                        </div>
                        <h4>{{ \Illuminate\Support\Str::limit($blog->title, 60, '...') }}</h4>
                        <div class="blog-bottom">
                            <p>{{ \Illuminate\Support\Str::limit($blog->summary, 90, '...') }}</p>
                            <span  class="tr-white-btn-large ">{{get_phrase('Read Now!')}}</span>
                        </div>
                    </div>
                </a>
            </div>
            @else
            <div class="col-lg-6 col-md-6 col-sm-12">
                <a href="{{ route('blog_details', ['slug' => $blog->slug]) }}" class="tr-blog">
                    <div class="tr-big-image">
                        <img src="{{ get_image($blog->thumbnail) }}" alt="">
                    </div>
                    <div class="tr-blog-content">
                        <div class="blog-head">
                            <div class="d-flex align-items-center">
                                <img src="{{ asset('assets/frontend/travel-dark/images/bg-cal.svg') }}" alt="">
                                <p>{{ $blog->created_at->format('d M, Y') }}</p>
                            </div>
                             
                        </div>
                        <h4>{{ \Illuminate\Support\Str::limit($blog->title, 60, '...') }}</h4>
                        <div class="blog-bottom">
                            <p>{{ \Illuminate\Support\Str::limit($blog->summary, 90, '...') }}</p>
                            <span  class="tr-white-btn-large ">{{get_phrase('Read Now!')}}</span>
                        </div>
                    </div>
                </a>
            </div>
            @endif
            @endforeach
        </div>
        <div class="text-center mt-2 wow animate__fadeInUp" data-wow-delay=".1s">
            <a href="{{route('blog')}}" class="tr-white-btn-large px-28px mt-5">{{get_phrase('Read All Blogs')}}</a>
        </div>

    </div>
</section>
<!-- Blog Section End -->