  <style>
      .ba-header-section{
       background: transparent !important;   
    }
    .ba-btns-wrap .bab2-btn-outline-dark{
        background: transparent !important;
    }
    .new-arrivals-section .product-card{
        background: transparent !important;
    }
  </style>
    
    <!-- Start Banner Section  -->
    <section class="banner-section">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="banner-content-area">
                        <div class="swiper ba-banner-slider">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide">
                                    <div class="ba-banner-slide">
                                        <div class="bn-title-badge">
                                            <p class="type">{{get_phrase('New')}}</p>
                                            <p class="category">{{get_phrase('All Baby’s Accessories')}}</p>
                                        </div>
                                        <h1 class="ba-banner-title">{{get_phrase('Everything Your Baby Needs All in One Place!')}}</h1>
                                        <p class="ba-banner-subtitle">{{get_phrase('Safe, adorable & handpicked by parents.')}}</p>
                                        <div class="ba-btns-wrap">
                                            <a href="{{route('all_products')}}" class="btn bab2-btn-white">
                                                <span>{{get_phrase('Shop Now')}}</span>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" viewBox="0 0 11 11" fill="none">
                                                    <path d="M2.4375 1.14179C2.40683 1.65843 2.76563 2.08629 3.23896 2.09728L7.5956 2.19832L0.712227 9.10554C0.355865 9.46313 0.320697 10.0555 0.633679 10.4287C0.946662 10.8018 1.48931 10.8144 1.84567 10.4568L8.72918 3.54946L8.44686 8.30581C8.41615 8.8225 8.775 9.25031 9.24832 9.2613C9.72164 9.27228 10.1302 8.86233 10.1609 8.3456L10.5772 1.33062C10.592 1.08244 10.5158 0.842404 10.3655 0.663225C10.2152 0.484047 10.0031 0.380413 9.77577 0.375137L3.35 0.226058C2.87672 0.215115 2.46817 0.625067 2.4375 1.14179Z" fill="black"></path>
                                                </svg>
                                            </a>
                                            
                                        </div>
                                    </div>
                                </div>
                              
                            </div>
                            <div class="hero-banner-nav">
                                <div class="swiper-button-prev">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="39" height="25" viewBox="0 0 39 25" fill="none">
                                        <path d="M14.2948 1.14912C15.2003 1.41559 15.2004 1.41664 15.2004 1.41689L15.1994 1.41693L15.1994 1.41888C15.199 1.4201 15.1982 1.42207 15.1977 1.42383C15.1965 1.42766 15.1952 1.43335 15.1933 1.43962C15.1893 1.4528 15.183 1.47159 15.1758 1.49496C15.161 1.54233 15.1399 1.61079 15.1116 1.69659C15.0549 1.86875 14.9701 2.1147 14.8577 2.41603C14.6332 3.0185 14.2943 3.8495 13.8352 4.76736C12.9285 6.58023 11.502 8.83722 9.47533 10.295C8.65876 10.8824 7.81205 11.3802 6.98631 11.8015L38.5669 10.6778L38.6341 12.5653L7.05347 13.689C7.90715 14.0505 8.78693 14.4868 9.64326 15.0147C11.7685 16.3249 13.3517 18.4746 14.385 20.2185C14.9082 21.1015 15.3052 21.9062 15.5721 22.4912C15.7055 22.7839 15.8076 23.0231 15.8764 23.1908C15.9107 23.2745 15.9367 23.3412 15.9547 23.3874C15.9637 23.4102 15.9713 23.4285 15.9762 23.4413C15.9786 23.4475 15.9802 23.453 15.9816 23.4568C15.9823 23.4585 15.9833 23.4604 15.9838 23.4616L15.9838 23.4635L15.9848 23.4635C15.9814 23.4651 15.9273 23.4863 15.1005 23.7949L14.2162 24.1254L14.2152 24.1235L14.1968 24.0743C14.1824 24.0375 14.1594 23.9811 14.1293 23.9077C14.0689 23.7603 13.9771 23.5438 13.8547 23.2754C13.6093 22.7372 13.2426 21.994 12.761 21.1812C11.7842 19.5327 10.3912 17.6939 8.65293 16.6222C6.82756 15.497 4.85071 14.814 3.3151 14.4122C2.55081 14.2123 1.90379 14.0832 1.45083 14.0056C1.22493 13.9668 1.04774 13.9407 0.929063 13.9245C0.869752 13.9164 0.824316 13.9112 0.79557 13.9077C0.781629 13.906 0.77139 13.9046 0.765142 13.9039C0.762052 13.9036 0.759313 13.9033 0.758276 13.9032L0.791407 12.9668L0.69181 12.0352C0.692826 12.035 0.695591 12.0346 0.698607 12.034C0.704773 12.0329 0.714953 12.0307 0.728688 12.0281C0.757096 12.0225 0.802121 12.0141 0.860652 12.0019C0.977857 11.9772 1.15282 11.9385 1.37534 11.8839C1.82159 11.7742 2.45792 11.5995 3.20599 11.3458C4.70909 10.8359 6.63254 10.014 8.37324 8.76196C10.0308 7.56953 11.2897 5.63626 12.1469 3.92256C12.5695 3.07765 12.8824 2.31015 13.089 1.75586C13.192 1.47963 13.2681 1.25704 13.318 1.1057C13.3428 1.03042 13.3617 0.972504 13.3735 0.934675L13.3883 0.884312L13.3892 0.882325L14.2948 1.14912Z" fill="black"/>
                                    </svg>
                                </div>
                                <div class="swiper-pagination"></div>
                                <div class="swiper-button-next">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="39" height="24" viewBox="0 0 39 24" fill="none">
                                        <path d="M24.2109 0.795814C23.3266 1.12595 23.3265 1.12703 23.3266 1.12727L23.3276 1.12724L23.3276 1.12919C23.3281 1.13038 23.3291 1.13227 23.3298 1.134C23.3312 1.13775 23.3329 1.14331 23.3352 1.14944C23.3401 1.16231 23.3477 1.18058 23.3567 1.2034C23.3747 1.2496 23.4007 1.31636 23.435 1.39996C23.5038 1.56765 23.6059 1.80693 23.7394 2.09954C24.0062 2.68453 24.4032 3.48931 24.9264 4.37224C25.9597 6.11609 27.543 8.26597 29.6681 9.57606C30.5244 10.1039 31.4043 10.5402 32.2579 10.9018L0.677345 12.0255L0.744505 13.913L32.3251 12.7893C31.4993 13.2106 30.6527 13.7083 29.8361 14.2957C27.8094 15.7536 26.3829 18.0105 25.4762 19.8234C25.0171 20.7413 24.6782 21.5723 24.4537 22.1747C24.3413 22.4761 24.2565 22.722 24.1998 22.8942C24.1715 22.98 24.1504 23.0485 24.1356 23.0958C24.1283 23.1192 24.122 23.138 24.1181 23.1511C24.1162 23.1575 24.1149 23.1631 24.1137 23.1669C24.1132 23.1687 24.1123 23.1707 24.112 23.1719L24.112 23.1738L24.1111 23.1739C24.1135 23.1749 24.1603 23.1896 25.0167 23.4416L25.9222 23.7084L25.9231 23.7064L25.938 23.6561C25.9497 23.6183 25.9686 23.5604 25.9934 23.4851C26.0433 23.3338 26.1194 23.1112 26.2224 22.8349C26.429 22.2806 26.7419 21.5132 27.1645 20.6682C28.0217 18.9545 29.2805 17.0213 30.9382 15.8288C32.6789 14.5767 34.6023 13.7549 36.1054 13.245C36.8536 12.9912 37.4898 12.8166 37.9361 12.7069C38.1587 12.6522 38.3335 12.6135 38.4508 12.5889C38.5094 12.5766 38.5543 12.5682 38.5827 12.5627C38.5965 12.56 38.6066 12.5579 38.6128 12.5568C38.6159 12.5562 38.6185 12.5557 38.6196 12.5555L38.52 11.6239L38.5531 10.6876C38.5521 10.6875 38.5494 10.6872 38.5463 10.6868C38.54 10.6861 38.5298 10.6847 38.5158 10.683C38.4871 10.6796 38.4417 10.6744 38.3824 10.6663C38.2637 10.6501 38.0865 10.6239 37.8606 10.5852C37.4076 10.5075 36.7606 10.3785 35.9963 10.1786C34.4608 9.77682 32.4838 9.09374 30.6585 7.96854C28.9203 6.89693 27.5272 5.05804 26.5504 3.40959C26.0688 2.59682 25.7022 1.85353 25.4567 1.31532C25.3344 1.04708 25.2426 0.830493 25.1821 0.683082C25.152 0.609727 25.129 0.553328 25.1146 0.516431L25.0962 0.467248L25.0952 0.465331L24.2109 0.795814Z" fill="black"/>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Banner Section  -->

    <!-- Start Benefit Section  -->
    <section class="section-mb wow animate__fadeInUp" data-wow-delay=".1s">
        <div class="container">
            <div class="row g-4">
                <div class="col-sm-6 col-lg-4 col-xl-3">
                    <div>
                        <div class="benefit-icon">
                            <img class="icon" src="{{ asset('assets/frontend/baby/images/benefit-icon1.png') }}" alt="">
                        </div>
                        <h4 class="benefit-title">{{get_phrase('100% Baby-Safe Materials')}}</h4>
                        <p class="benefit-subtitle">{{get_phrase('Non-toxic, gentle & quality-verified.')}}</p>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-4 col-xl-3">
                    <div>
                        <div class="benefit-icon">
                            <img class="icon" src="{{ asset('assets/frontend/baby/images/benefit-icon2.png') }}" alt="">
                        </div>
                        <h4 class="benefit-title">{{get_phrase('Pediatrician Recommended')}}</h4>
                        <p class="benefit-subtitle">{{get_phrase('Backed by experts who care.')}}</p>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-4 col-xl-3">
                    <div>
                        <div class="benefit-icon">
                            <img class="icon" src="{{ asset('assets/frontend/baby/images/benefit-icon3.png') }}" alt="">
                        </div>
                        <h4 class="benefit-title">{{get_phrase('Hassle-Free Returns')}}</h4>
                        <p class="benefit-subtitle">{{get_phrase('Because your peace of mind matters.')}}</p>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-4 col-xl-3">
                    <div>
                        <div class="benefit-icon">
                            <img class="icon" src="{{ asset('assets/frontend/baby/images/benefit-icon4.png') }}" alt="">
                        </div>
                        <h4 class="benefit-title">{{get_phrase('Fast & Reliable Shipping')}}</h4>
                        <p class="benefit-subtitle">{{get_phrase('Get what you need, right when you need it')}}</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Benefit Section  -->

    <!-- Start Category Section  -->
    <section class="category-section-mb">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="category-section-title-area">
                        <div class="text-center wow animate__fadeInUp" data-wow-delay=".1s">
                            <p class="section-sm-title mb-30px"><span class="line"></span>{{get_phrase('Shop by Category')}}<span class="line"></span></p>
                        </div>
                        <h2 class="section-title text-center max-w-690px mx-auto mb-26px wow animate__fadeInUp" data-wow-delay=".2s">{{get_phrase("Essentials for Every Stage of Your Baby's Growth!")}}</h2>
                        <p class="section-subtitle max-w-584px mx-auto text-center mb-36px wow animate__fadeInUp" data-wow-delay=".3s">{{get_phrase("From cozy clothing to travel-ready gear, find everything your little one needs — all in one place.")}}</p>
                        <div class="text-center wow animate__fadeInUp" data-wow-delay=".4s">
                            <a href="{{route('all_products')}}" class="btn ba-btn-outline-dark">
                                <span>{{get_phrase("View All Categories")}}</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" viewBox="0 0 11 11" fill="none">
                                    <path d="M2.4375 1.14179C2.40683 1.65843 2.76563 2.08629 3.23896 2.09728L7.5956 2.19832L0.712227 9.10554C0.355865 9.46313 0.320697 10.0555 0.633679 10.4287C0.946662 10.8018 1.48931 10.8144 1.84567 10.4568L8.72918 3.54946L8.44686 8.30581C8.41615 8.8225 8.775 9.25031 9.24832 9.2613C9.72164 9.27228 10.1302 8.86233 10.1609 8.3456L10.5772 1.33062C10.592 1.08244 10.5158 0.842404 10.3655 0.663225C10.2152 0.484047 10.0031 0.380413 9.77577 0.375137L3.35 0.226058C2.87672 0.215115 2.46817 0.625067 2.4375 1.14179Z" fill="black"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row wow animate__fadeInUp" data-wow-delay=".5s">
                <div class="col-12">
                    <!-- Swiper -->
                    <div class="swiper category-slider"> 
                        <div class="swiper-wrapper">
                             @php
                                $categories = App\Models\Category::where('parent_id', '=', 0)->orderBy('sort', 'asc')->orderBy('title', 'asc')->get();
                            @endphp
                            @foreach($categories as $category)
                                <div class="swiper-slide">
                                    <div class="category-slide">
                                        <a href="{{ route('products', get_category_params($category)) }}" class="category-banner">
                                            <img class="banner" src="{{ get_image($category->thumbnail) }}" alt="">
                                        </a>
                                        <a href="{{ route('products', get_category_params($category)) }}" class="category-title">{{$category->title}}</a>
                                        <p class="category-subtitle">{{ \Illuminate\Support\Str::limit($category->description, 50, '...') }}</p>
                                    </div>
                                </div>
                            @endforeach

                        </div>
                        <div class="category-pagination">
                            <div class="swiper-button-prev">
                                <svg width="10" height="18" viewBox="0 0 10 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M8.88189 1.23535L1.11719 9.00006L8.88189 16.7648" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>
                            <div class="swiper-button-next">
                                <svg width="10" height="18" viewBox="0 0 10 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M1.11811 16.7646L8.88281 8.99994L1.11811 1.23524" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Category Section  -->

    <!-- Start Trending Products Section  -->
    <section class="section-mb">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div>
                        <p class="section-sm-title mb-30px wow animate__fadeInUp" data-wow-delay=".1s"><span class="line"></span>{{get_phrase('Trending Products')}}<span class="line"></span></p>
                        <div class="tp-section-title-wrap">
                            <div class="tp-section-title-left">
                                <h2 class="section-title wow animate__fadeInUp" data-wow-delay=".2s">{{get_phrase('Our most-loved products by moms & dads everywhere!')}}</h2>
                            </div>
                            <div class="tp-section-title-right">
                                <p class="section-subtitle wow animate__fadeInUp" data-wow-delay=".3s">{{get_phrase('Discover the top picks trusted by thousands of happy parents. These bestsellers are flying off the shelves—for good reason!')}}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row g-4 trending-products-wrap wow animate__fadeInUp" data-wow-delay=".4s">
               @php 
               use Illuminate\Support\Facades\DB;
                $trendyProducts = App\Models\Product::select(
                            'products.*',
                            DB::raw('COUNT(reviews.id) as review_count'),
                            DB::raw('AVG(reviews.rating) as avg_rating')
                        )
                        ->leftJoin('reviews', 'products.id', '=', 'reviews.product_id')
                        ->where('products.status', 1)
                        ->groupBy('products.id')
                        ->orderByDesc('review_count')
                        ->take(4)
                        ->get();
               @endphp
                @foreach($trendyProducts as $product)
                <div class="col-sm-6 col-lg-4 col-xl-3">
                    <a href="{{ route('product', $product->slug) }}" class="product-card">
                        <div class="product-card-banner">
                            @php
                                $thumbnails = json_decode($product->thumbnail, true);
                                $firstImage = $thumbnails[0] ?? null;
                            @endphp
                            <img class="banner" src="{{ get_image($firstImage) }}" alt="">
                        </div>
                        <div>
                            <h4 class="product-card-title">{{$product->title}}</h4>
                            <p class="product-card-category capitalize">{{$product->quality_label}}</p>
                            <div class="pc-price-rating-wrap">
                                
                                 @if ($product->is_discounted)
                                    @php
                                        $discount = $product->discount;
                                    @endphp
                                    @if ($discount->discount_type == 'percentage')
                                        <h4 class="product-card-price">{{ currency(($product->price / 100) * $discount->discount_value) }}</h4>
                                    @else
                                        <h4 class="product-card-price">{{ currency($product->price) }}</h4>
                                    @endif
                                @else
                                   <h4 class="product-card-price">{{ currency($product->price) }}</h4>
                                @endif
                                <div class="pc-rating-wrap">
                                    <div class="pc-stars">
                                              @php
                                                $rating = $product->average_rating;
                                                $fullStars = floor($rating); // full stars count
                                                $halfStar = ($rating - $fullStars) >= 0.5 ? 1 : 0; // half star check
                                                $emptyStars = 5 - ($fullStars + $halfStar);
                                            @endphp
                                            <div class="pc-star">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="17" viewBox="0 0 18 17" fill="none">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M8.87419 1.37819L10.8921 5.67108L15.5986 6.25785C16.0344 6.314 16.3532 6.71613 16.2972 7.15215C16.269 7.36466 16.1629 7.54887 16.0119 7.67781L12.586 10.8861L13.4802 15.5477C13.5638 15.9837 13.279 16.4029 12.8428 16.4867C12.6529 16.5201 12.4629 16.4867 12.3063 16.3973L8.14748 14.1113L3.99475 16.3973C3.60363 16.6152 3.11729 16.47 2.905 16.0842C2.80976 15.911 2.78752 15.7208 2.82121 15.5477L3.70968 10.8861L0.250176 7.63851C-0.0688001 7.33659 -0.0856451 6.82821 0.21627 6.50945C0.350383 6.36411 0.524016 6.28593 0.702617 6.26347V6.25785L5.40886 5.67108L7.42659 1.37819C7.61125 0.975855 8.08657 0.808268 8.4887 0.9927C8.66751 1.07649 8.79623 1.21622 8.87419 1.37819Z"
                                                        fill="#FFD23C"/>
                                                </svg>
                                            </div>
                                       </div>
                                    <p class="pc-total-rating">({{ number_format($product->average_rating, 1) }})</p>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                @endforeach
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="text-center">
                        <a href="{{route('all_products')}}" class="btn ba-btn-outline-dark">
                            <span>{{get_phrase('View All Products')}}</span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" viewBox="0 0 11 11" fill="none">
                                <path d="M2.4375 1.14179C2.40683 1.65843 2.76563 2.08629 3.23896 2.09728L7.5956 2.19832L0.712227 9.10554C0.355865 9.46313 0.320697 10.0555 0.633679 10.4287C0.946662 10.8018 1.48931 10.8144 1.84567 10.4568L8.72918 3.54946L8.44686 8.30581C8.41615 8.8225 8.775 9.25031 9.24832 9.2613C9.72164 9.27228 10.1302 8.86233 10.1609 8.3456L10.5772 1.33062C10.592 1.08244 10.5158 0.842404 10.3655 0.663225C10.2152 0.484047 10.0031 0.380413 9.77577 0.375137L3.35 0.226058C2.87672 0.215115 2.46817 0.625067 2.4375 1.14179Z" fill="black"></path>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Trending Products Section  -->

    <!-- Start New Arrivals Section  -->
    <section class="section-mb new-arrivals-section">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="na-section-title-area">
                        <div class="text-center wow animate__fadeInUp" data-wow-delay=".1s">
                            <p class="section-sm-title mb-30px"><span class="line"></span>{{get_phrase('New Arrivals')}}<span class="line"></span></p>
                        </div>
                        <h2 class="section-title text-center max-w-690px mx-auto mb-3 wow animate__fadeInUp" data-wow-delay=".2s">{{get_phrase('Fresh finds for your little one')}}</h2>
                        <p class="section-subtitle max-w-682px mx-auto text-center mb-36px wow animate__fadeInUp" data-wow-delay=".3s">{{get_phrase('Explore the newest baby essentials loved by parents and little ones alike.')}}</p>
                        <div class="text-center wow animate__fadeInUp" data-wow-delay=".4s">
                            <a href="{{route('all_products')}}" class="btn ba-btn-outline-dark">
                                <span>{{get_phrase('View All Products')}}</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" viewBox="0 0 11 11" fill="none">
                                    <path d="M2.4375 1.14179C2.40683 1.65843 2.76563 2.08629 3.23896 2.09728L7.5956 2.19832L0.712227 9.10554C0.355865 9.46313 0.320697 10.0555 0.633679 10.4287C0.946662 10.8018 1.48931 10.8144 1.84567 10.4568L8.72918 3.54946L8.44686 8.30581C8.41615 8.8225 8.775 9.25031 9.24832 9.2613C9.72164 9.27228 10.1302 8.86233 10.1609 8.3456L10.5772 1.33062C10.592 1.08244 10.5158 0.842404 10.3655 0.663225C10.2152 0.484047 10.0031 0.380413 9.77577 0.375137L3.35 0.226058C2.87672 0.215115 2.46817 0.625067 2.4375 1.14179Z" fill="black"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row g-4 wow animate__fadeInUp" data-wow-delay=".4s">
                
                @foreach($popular_products as $product)
                <div class="col-sm-6 col-lg-4 col-xl-3">
                    <a href="{{ route('product', $product->slug) }}" class="product-card">
                        <div class="product-card-banner">
                            @php
                                $thumbnails = json_decode($product->thumbnail, true);
                                $firstImage = $thumbnails[0] ?? null;
                            @endphp
                            <img class="banner" src="{{ get_image($firstImage) }}" alt="">
                        </div>
                        <div>
                            <h4 class="product-card-title">{{$product->title}}</h4>
                            <p class="product-card-category capitalize">{{$product->quality_label}}</p>
                            <div class="pc-price-rating-wrap">
                                
                                 @if ($product->is_discounted)
                                    @php
                                        $discount = $product->discount;
                                    @endphp
                                    @if ($discount->discount_type == 'percentage')
                                        <h4 class="product-card-price">{{ currency(($product->price / 100) * $discount->discount_value) }}</h4>
                                    @else
                                        <h4 class="product-card-price">{{ currency($product->price) }}</h4>
                                    @endif
                                @else
                                   <h4 class="product-card-price">{{ currency($product->price) }}</h4>
                                @endif
                                 <div class="pc-stars-ratings d-flex">
                                     <div class=" d-flex align-items-center">
                                            @php
                                                $rating = $product->average_rating;
                                                $fullStars = floor($rating); // full stars count
                                                $halfStar = ($rating - $fullStars) >= 0.5 ? 1 : 0; // half star check
                                                $emptyStars = 5 - ($fullStars + $halfStar);
                                            @endphp
                                            <div class="svg-block">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="19" height="20" viewBox="0 0 19 20" fill="none">
                                                    <path d="M9.39444 1.91455L6.72279 7.33149L0.751221 8.19515L5.07283 12.4136L4.05115 18.3651L9.39444 15.5568L14.7377 18.3651L13.7161 12.4136L18.0377 8.20103L12.0661 7.33149L9.39444 1.91455Z" fill="#FFD23C"/>
                                                </svg>
                                            </div>
                                      </div>
                                    <p>({{ number_format($product->average_rating, 1) }})</p>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                @endforeach

            </div>
        </div>
    </section>
    <!-- End New Arrivals Section  -->

    <!-- Start News & Insights Section  -->
    <section class="section-mb overflow-hidden">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="ni-section-title-area">
                        <div class="text-center wow animate__fadeInUp" data-wow-delay=".1s">
                            <p class="section-sm-title mb-30px"><span class="line"></span>{{get_phrase('News & Insights')}}<span class="line"></span></p>
                        </div>
                        <h2 class="section-title text-center max-w-712px mx-auto mb-3 wow animate__fadeInUp" data-wow-delay=".2s">{{get_phrase('Parenting Tips & Expert Advice!')}}</h2>
                        <p class="section-subtitle max-w-584px mx-auto text-center mb-36px wow animate__fadeInUp" data-wow-delay=".3s">{{get_phrase('Helpful articles, parenting tips, and expert advice')}}</p>
                        <div class="text-center wow animate__fadeInUp" data-wow-delay=".4s">
                            <a href="{{route('blog')}}" class="btn ba-btn-outline-dark">
                                <span>{{get_phrase('Read All Blogs')}}</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" viewBox="0 0 11 11" fill="none">
                                    <path d="M2.4375 1.14179C2.40683 1.65843 2.76563 2.08629 3.23896 2.09728L7.5956 2.19832L0.712227 9.10554C0.355865 9.46313 0.320697 10.0555 0.633679 10.4287C0.946662 10.8018 1.48931 10.8144 1.84567 10.4568L8.72918 3.54946L8.44686 8.30581C8.41615 8.8225 8.775 9.25031 9.24832 9.2613C9.72164 9.27228 10.1302 8.86233 10.1609 8.3456L10.5772 1.33062C10.592 1.08244 10.5158 0.842404 10.3655 0.663225C10.2152 0.484047 10.0031 0.380413 9.77577 0.375137L3.35 0.226058C2.87672 0.215115 2.46817 0.625067 2.4375 1.14179Z" fill="black"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row gx-20px gy-4">
                <div class="col-lg-10 offset-lg-1 col-xl-8 offset-xl-0">
                    @foreach($blogs->take(2) as $blog)
                    <a href="{{ route('blog_details', ['slug' => $blog->slug]) }}" class="blog-list-card mb-4 wow animate__fadeInUp" data-wow-delay=".1s">
                        <div class="row gx-20px gy-4">
                            <div class="col-md-5">
                                    <div class="blog-list-banner">
                                    <img class="banner" src="{{ get_image($blog->thumbnail) }}" alt="">
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="blog-list-body">
                                    <div class="blog-datetime-wrap">
                                        <p class="date">{{ $blog->created_at->format('d M, Y') }}</p>
                                        
                                    </div>
                                    <h4 class="blog-list-title">{{ $blog->title }}</h4>
                                    <p class="blog-list-subtitle">{{ \Illuminate\Support\Str::limit($blog->summary, 80, '...') }}</p>
                                    <p class="blog-real-btn">
                                        <span>{{get_phrase('Read More')}}</span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="12" viewBox="0 0 16 12" fill="none">
                                            <path d="M15.5303 6.4483C15.8232 6.15541 15.8232 5.68053 15.5303 5.38764L10.7574 0.614668C10.4645 0.321774 9.98959 0.321774 9.6967 0.614668C9.40381 0.907561 9.40381 1.38243 9.6967 1.67533L13.9393 5.91797L9.6967 10.1606C9.40381 10.4535 9.40381 10.9284 9.6967 11.2213C9.98959 11.5142 10.4645 11.5142 10.7574 11.2213L15.5303 6.4483ZM0 5.91797V6.66797H15V5.91797V5.16797H0V5.91797Z" fill="black"/>
                                        </svg>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </a>
                    @endforeach

                </div>
                <div class="col-md-6 col-lg-5 offset-lg-1 col-xl-4 offset-xl-0">
                    <div class="newsletter-card wow animate__fadeInRight" data-wow-delay=".3s">
                        <div class="w-100">
                            <div class="newsletter-img">
                                <img class="img" src="{{ asset('assets/frontend/baby/images/newsletter-img.png') }}" alt="">
                            </div>
                            <h3 class="newsletter-card-title">{{get_phrase('Sign Up to Receive Recent Latest News From Us!')}}</h3>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End News & Insights Section  -->

    <!-- Start Seasonal Collections Section  -->
    <section class="section-mb overflow-hidden">
        <div class="container">
            <div class="row g-4 justify-content-center align-items-center">
                <div class="col-md-10 col-lg-6">
                    <div class="seasonal-collection-banner me-lg-2 wow animate__fadeInLeft" data-wow-delay=".1s">
                        <img class="banner" src="{{ asset('assets/frontend/baby/images/seasonal-collection-banner.webp ') }}" alt="">
                        <div class="sc-banner-overlay">
                            <h4 class="scb-overlay-off">{{get_phrase('-50% off')}}</h4>
                            <h4 class="scb-overlay-title">{{get_phrase('Summer Essentials for Your Baby')}}</h4>
                            <p class="scb-overlay-subtitle">{{get_phrase('Light and breathable must-haves for warmer days')}}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-10 col-lg-6">
                    <div class="ps-lg-4 mt-3 mt-lg-0">
                        <p class="section-sm-title mb-30px wow animate__fadeInUp" data-wow-delay=".2s"><span class="line"></span>{{get_phrase('Seasonal Collections')}}<span class="line"></span></p>
                        <h2 class="section-title mb-3 wow animate__fadeInUp" data-wow-delay=".3s">{{get_phrase('Curated Collections Just for You!')}}</h2>
                        <p class="section-subtitle mb-36px wow animate__fadeInUp" data-wow-delay=".4s">{{get_phrase('Keep your little one cool and comfortable with our handpicked summer must-haves. From breathable fabrics to sun-safe accessories, everything is designed for warmer days and outdoor fun. Perfect for stroll.')}}</p>
                        <a href="{{route('all_products')}}" class="btn ba-btn-outline-dark wow animate__fadeInUp" data-wow-delay=".5s">
                            <span>{{get_phrase('View All Products')}}</span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" viewBox="0 0 11 11" fill="none">
                                <path d="M2.4375 1.14179C2.40683 1.65843 2.76563 2.08629 3.23896 2.09728L7.5956 2.19832L0.712227 9.10554C0.355865 9.46313 0.320697 10.0555 0.633679 10.4287C0.946662 10.8018 1.48931 10.8144 1.84567 10.4568L8.72918 3.54946L8.44686 8.30581C8.41615 8.8225 8.775 9.25031 9.24832 9.2613C9.72164 9.27228 10.1302 8.86233 10.1609 8.3456L10.5772 1.33062C10.592 1.08244 10.5158 0.842404 10.3655 0.663225C10.2152 0.484047 10.0031 0.380413 9.77577 0.375137L3.35 0.226058C2.87672 0.215115 2.46817 0.625067 2.4375 1.14179Z" fill="black"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Seasonal Collections Section  -->

    <!-- Start Testimonials Section  -->
    <section class="section-mb">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="tm-section-title-area">
                        <div class="text-center wow animate__fadeInUp" data-wow-delay=".1s">
                            <p class="section-sm-title mb-30px"><span class="line"></span>{{get_phrase('Customer Testimonials')}}<span class="line"></span></p>
                        </div>
                        <h2 class="section-title text-center max-w-712px mx-auto mb-3 wow animate__fadeInUp" data-wow-delay=".2s">{{get_phrase('Loved by Families Everywhere')}}</h2>
                        <p class="section-subtitle max-w-584px mx-auto text-center mb-36px wow animate__fadeInUp" data-wow-delay=".3s">{{get_phrase('Real stories from happy parents')}}</p>
                        <div class="text-center wow animate__fadeInUp" data-wow-delay=".4s">
                            <a href="{{route('contact_us')}}" class="btn ba-btn-outline-dark px-30px">
                                <span>{{get_phrase('Contact us')}}</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" viewBox="0 0 11 11" fill="none">
                                    <path d="M2.4375 1.14179C2.40683 1.65843 2.76563 2.08629 3.23896 2.09728L7.5956 2.19832L0.712227 9.10554C0.355865 9.46313 0.320697 10.0555 0.633679 10.4287C0.946662 10.8018 1.48931 10.8144 1.84567 10.4568L8.72918 3.54946L8.44686 8.30581C8.41615 8.8225 8.775 9.25031 9.24832 9.2613C9.72164 9.27228 10.1302 8.86233 10.1609 8.3456L10.5772 1.33062C10.592 1.08244 10.5158 0.842404 10.3655 0.663225C10.2152 0.484047 10.0031 0.380413 9.77577 0.375137L3.35 0.226058C2.87672 0.215115 2.46817 0.625067 2.4375 1.14179Z" fill="black"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row wow animate__fadeInUp" data-wow-delay=".5s">
                <div class="col-12">
                    <!-- Swiper -->
                    <div class="swiper testimonial-slider">
                        <div class="swiper-wrapper">
                           @foreach($reviews->take(5) as $review) 
                                <div class="swiper-slide">
                                    <div class="testimonial-card">
                                        <p class="testimonial-comment">{{ $review->comment }}</p>
                                        <div class="tm-user-rating-wrap">
                                            <div>
                                                <h5 class="tm-user-name">{{ $review->user->name }}</h5>
                                            </div>
                                            <div class="tm-rating-stars d-flex">
                                                @php
                                                    $rating = $review->rating; 
                                                @endphp
                                                @for ($i = 1; $i <= $rating; $i++)
                                                    <div class="tm-star">
                                                        <svg width="28" height="27" viewBox="0 0 28 27" xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M13.9874 22.3802L6.52243 26.8063C6.34787 26.9099 6.14578 26.9609 5.94157 26.9529C5.73735 26.9448 5.54015 26.8781 5.37475 26.761C5.20935 26.644 5.08315 26.4818 5.01202 26.2951C4.9409 26.1083 4.92802 25.9051 4.975 25.7112L6.98666 17.4207L0.360344 11.8671C0.205451 11.7372 0.0934238 11.5655 0.0383478 11.3737C-0.0167282 11.1818 -0.0123938 10.9784 0.0508059 10.789C0.114006 10.5995 0.233249 10.4325 0.393542 10.309C0.553835 10.1854 0.748021 10.1108 0.951683 10.0945L9.66013 9.39817L13.0313 1.53865C13.1101 1.3548 13.2429 1.19778 13.4131 1.08734C13.5832 0.976896 13.783 0.917969 13.9874 0.917969C14.1918 0.917969 14.3916 0.976896 14.5617 1.08734C14.7319 1.19778 14.8647 1.3548 14.9435 1.53865L18.3147 9.39817L27.0231 10.0945C27.2267 10.111 27.4207 10.1858 27.5808 10.3095C27.7409 10.4331 27.8599 10.6001 27.923 10.7895C27.986 10.9789 27.9902 11.1823 27.9351 11.374C27.88 11.5657 27.7679 11.7373 27.6131 11.8671L20.9881 17.4207L22.9998 25.7112C23.0468 25.9051 23.0339 26.1083 22.9628 26.2951C22.8917 26.4818 22.7655 26.644 22.6001 26.761C22.4347 26.8781 22.2375 26.9448 22.0332 26.9529C21.829 26.9609 21.6269 26.9099 21.4524 26.8063L13.9874 22.3802Z" fill="#FFD23C"/>
                                                        </svg>
                                                    </div>
                                                @endfor

                                                @for ($i = $rating+1; $i <= 5; $i++)
                                                    <div class="tm-star">
                                                        <svg width="28" height="27" viewBox="0 0 28 27" xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M13.9874 22.3802L6.52243 26.8063C6.34787 26.9099 6.14578 26.9609 5.94157 26.9529C5.73735 26.9448 5.54015 26.8781 5.37475 26.761C5.20935 26.644 5.08315 26.4818 5.01202 26.2951C4.9409 26.1083 4.92802 25.9051 4.975 25.7112L6.98666 17.4207L0.360344 11.8671C0.205451 11.7372 0.0934238 11.5655 0.0383478 11.3737C-0.0167282 11.1818 -0.0123938 10.9784 0.0508059 10.789C0.114006 10.5995 0.233249 10.4325 0.393542 10.309C0.553835 10.1854 0.748021 10.1108 0.951683 10.0945L9.66013 9.39817L13.0313 1.53865C13.1101 1.3548 13.2429 1.19778 13.4131 1.08734C13.5832 0.976896 13.783 0.917969 13.9874 0.917969C14.1918 0.917969 14.3916 0.976896 14.5617 1.08734C14.7319 1.19778 14.8647 1.3548 14.9435 1.53865L18.3147 9.39817L27.0231 10.0945C27.2267 10.111 27.4207 10.1858 27.5808 10.3095C27.7409 10.4331 27.8599 10.6001 27.923 10.7895C27.986 10.9789 27.9902 11.1823 27.9351 11.374C27.88 11.5657 27.7679 11.7373 27.6131 11.8671L20.9881 17.4207L22.9998 25.7112C23.0468 25.9051 23.0339 26.1083 22.9628 26.2951C22.8917 26.4818 22.7655 26.644 22.6001 26.761C22.4347 26.8781 22.2375 26.9448 22.0332 26.9529C21.829 26.9609 21.6269 26.9099 21.4524 26.8063L13.9874 22.3802Z" fill="#ddd"/>
                                                        </svg>
                                                    </div>
                                                @endfor
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach

                          

                        </div>
                        <div class="testimonial-nav">
                            <div class="swiper-button-prev">
                                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="20" viewBox="0 0 12 20" fill="none">
                                    <path d="M11.6181 1.49482L10.5264 0.234958L0.272445 9.94451L10.2835 19.9043L11.406 18.6718L2.66367 9.97404L11.6181 1.49482Z" fill="black"/>
                                </svg>
                            </div>
                            <div class="swiper-button-next">
                                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="20" viewBox="0 0 12 20" fill="none">
                                    <path d="M0.650434 1.49482L1.74215 0.234958L11.9961 9.94451L1.98503 19.9043L0.862541 18.6718L9.60488 9.97404L0.650434 1.49482Z" fill="black"/>
                                </svg>
                            </div>
                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Testimonials Section  -->