<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Shipping_address extends Model
{
    protected $fillable = [
        'title',
        'user_id',
        'country_id',
        'state_id',
        'city_id',
        'zip_code',
        'address',
        'is_primary',
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }
    public function country() {
        return $this->belongsTo(Country::class);
    }
    public function state() {
        return $this->belongsTo(State::class);
    }
    public function city() {
        return $this->belongsTo(City::class);
    }
}
