<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class InstallController extends Controller
{
    public  function index()
    {
        if (DB::connection()->getDatabaseName() != 'db_name') {
            return redirect('/login');
        } else {
            return redirect()->route('step0');
        }
    }

    public function step0()
    {
        return view('install.step0');
    }

    public function step1()
    {
        return view('install.step1');
    }

    function step2($param1 = '')
    {
        if ($param1 == 'error') {
            $error = 'Purchase Code Verification Failed';
        } else {
            $error = "";
        }
        return view('install.step2', ['error' => $error]);
    }

    public function validatePurchaseCode(Request $request)
    {
    $data = $request->all();
    $purchase_code = $data['purchase_code'];
    session(['purchase_code' => $purchase_code]);
    session(['purchase_code_verified' => 1]);
    //move to step 3
    return redirect()->route('step3');
}

    public function api_request($code = '')
    {
        $product_code = $code;
        $personal_token = "FkA9UyDiQT0YiKwYLK3ghyFNRVV9SeUn";
        $url = "https://api.envato.com/v3/market/author/sale?code=" . $product_code;
        $curl = curl_init($url);

        //setting the header for the rest of the api
        $bearer   = 'bearer ' . $personal_token;
        $header   = array();
        $header[] = 'Content-length: 0';
        $header[] = 'Content-type: application/json; charset=utf-8';
        $header[] = 'Authorization: ' . $bearer;

        $verify_url = 'https://api.envato.com/v1/market/private/user/verify-purchase:' . $product_code . '.json';
        $ch_verify = curl_init($verify_url . '?code=' . $product_code);

        curl_setopt($ch_verify, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch_verify, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch_verify, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch_verify, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($ch_verify, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);

        $cinit_verify_data = curl_exec($ch_verify);
        curl_close($ch_verify);

        $response = json_decode($cinit_verify_data, true);

        return true;
    }

    public function step3(Request $request)
    {
        $db_connection = "";
        $data = $request->all();
        $this->check_purchase_code_verification();

        if ($data) {

            $hostname = $data['hostname'];
            $username = $data['username'];
            $password = $data['password'];
            $dbname   = $data['dbname'];
            // check db connection using the above credentials
            $db_connection = $this->check_database_connection($hostname, $username, $password, $dbname);
            if ($db_connection == 'success') {
                // proceed to step 4
                session(['hostname' => $hostname]);
                session(['username' => $username]);
                session(['password' => $password]);
                session(['dbname' => $dbname]);
                return redirect()->route('step4');
            } else {

                return view('install.step3', ['db_connection' => $db_connection]);
            }
        }

        return view('install.step3', ['db_connection' => $db_connection]);
    }

    public function check_purchase_code_verification()
    {
    }

    public function check_database_connection($hostname, $username, $password, $dbname)
    {

        $newName = uniqid('db'); //example of unique name
        Config::set("database.connections." . $newName, [
            "host"      => $hostname,
            "port"      => env('DB_PORT', '3306'),
            "database"  => $dbname,
            "username"  => $username,
            "password"  => $password,
            'driver'    => env('DB_CONNECTION', 'mysql'),
            'charset'   => env('DB_CHARSET', 'utf8mb4'),
        ]);
        try {
            DB::connection($newName)->getPdo();
            return 'success';
        } catch (\Exception $e) {
            return 'Could not connect to the database.  Please check your configuration.';
        }
    }

    public function step4(Request $request)
    {
        $this->configure_database();
        return view('install.step4');
    }



    public function confirmInstall()
    {
        // run sql
        $this->run_blank_sql();

        // redirect to admin creation page
        return redirect()->route('step5');
    }

    public function step5() {
        return view('install.step5');
    }

    public function configure_database()
    {
        // write database.php
        $data_db = file_get_contents(base_path('config/database.php'));
        $data_db = str_replace('db_name',    session('dbname'),    $data_db);
        $data_db = str_replace('db_user',    session('username'),    $data_db);
        $data_db = str_replace('db_pass',    session('password'),    $data_db);
        $data_db = str_replace('db_host',    session('hostname'),    $data_db);
        file_put_contents(base_path('config/database.php'), $data_db);
    }

    public function run_blank_sql()
    {

        // Set line to collect lines that wrap
        $templine = '';
        // Read in entire file
        $lines = file(base_path('public/assets/install.sql'));
        // Loop through each line
        foreach ($lines as $line) {
            // Skip it if it's a comment
            if (substr($line, 0, 2) == '--' || $line == '')
                continue;
            // Add this line to the current templine we are creating
            $templine .= $line;
            // If it has a semicolon at the end, it's the end of the query so can process this templine
            if (substr(trim($line), -1, 1) == ';') {
                // Perform the query
                DB::statement($templine);

                // Reset temp variable to empty
                $templine = '';
            }
        }
    }

    public function finalizingSetup(Request $request)
    {

        $data = $request->all();
        if ($data) {
            /*system data*/
            $system_data['system_name']  = $data['system_name'];
            $system_data['timezone'] = $data['timezone'];
            if (session('purchase_code')) {
                $system_data['purchase_code']  = session('purchase_code');
            }

            foreach ($system_data as $key => $settings_data) {
                if (DB::table('settings')->where('type', $key)->count() == 0) {
                    DB::table('settings')->where('type', $key)->insert([
                        'type' => $key,
                        'description' => $settings_data,
                        'created_at' => date('Y-m-d H:i:s')
                    ]);
                } else {
                    DB::table('settings')->where('type', $key)->update([
                        'description' => $settings_data,
                    ]);
                }
            }

            /*admin data*/

            $admin_data['user_type'] = 'admin';
            $admin_data['role_id']      = 1;
            $admin_data['is_vendor']      = 1;
            $admin_data['name']      = $data['admin_name'];
            $admin_data['email']     = $data['admin_email'];
            $admin_data['phone']     = $data['admin_phone'];
            $admin_data['password']  = Hash::make($data['admin_password']);
            $admin_data['email_verified_at'] = date('Y-m-d H:i:s', time());
            $admin_data['created_at'] = date('Y-m-d H:i:s');

            $admin_id = DB::table('users')->insertGetId($admin_data);

            $store_id = DB::table('stores')->insertGetId([
                'user_id' => $admin_id,
                'name' => $data['system_name'], // or some default store name
                'slug' => Str::slug($data['system_name']),
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            /* create store settings */
            DB::table('store_settings')->insert([
                'store_id' => $store_id,
                'currency' => 'USD',
                'vat_type' => 'percentage',
                'vat_value' => 0,
                'shipping_cost' => 0,
                'timezone' => $data['timezone'],
                'store_email' => $data['admin_email'],
                'support_phone' => $data['admin_phone'],
                'created_at' => now(),
                'updated_at' => now(),
            ]);


            return redirect()->route('success');

            return view('install.success', ['admin_email' => $admin_data['email']]);
        }

        return view('install.step5');
    }

    public function success($param1 = '')
    {
        $this->configure_routes();

        if ($param1 == 'login') {
            return view('auth.login');
        }

        $admin_email = User::where('user_type', 'admin')->first()->email;

        $page_data['admin_email'] = $admin_email;
        $page_data['page_name'] = 'success';
        return view('install.success', ['admin_email' => $admin_email]);
    }

    public function configure_routes()
    {
        $data_routes = file_get_contents(base_path('routes/web.php'));
        $data_routes = str_replace("Route::get('/', 'index')",    "Route::get('/install_ended', 'index')",    $data_routes);
        file_put_contents(base_path('routes/web.php'), $data_routes);
    }
}
